/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.analysis;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.plugin.util.LayerNameGenerator;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.plugin.analysis.AttributePredicate;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;

public class AttributeQueryPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private static String ATTR_GEOMETRY_AREA = I18N.get("ui.plugin.analysis.AttributeQueryPlugIn.Geometry.Area");
    private static String ATTR_GEOMETRY_LENGTH = I18N.get("ui.plugin.analysis.AttributeQueryPlugIn.Geometry.Length");
    private static String ATTR_GEOMETRY_NUMPOINTS = I18N.get("ui.plugin.analysis.AttributeQueryPlugIn.Geometry.NumPoints");
    private static String ATTR_GEOMETRY_NUMCOMPONENTS = I18N.get("ui.plugin.analysis.AttributeQueryPlugIn.Geometry.NumComponents");
    private static String ATTR_GEOMETRY_ISCLOSED = I18N.get("ui.plugin.analysis.AttributeQueryPlugIn.Geometry.IsClosed");
    private static String ATTR_GEOMETRY_ISSIMPLE = I18N.get("ui.plugin.analysis.AttributeQueryPlugIn.Geometry.IsSimple");
    private static String ATTR_GEOMETRY_ISVALID = I18N.get("ui.plugin.analysis.AttributeQueryPlugIn.Geometry.IsValid");
    private static String ATTR_GEOMETRY_TYPE = I18N.get("ui.plugin.analysis.AttributeQueryPlugIn.Geometry.Type");
    private Collection functionNames;
    private MultiInputDialog dialog;
    private Layer srcLayer;
    private String attrName;
    private String funcNameToRun;
    private String value = "";
    private boolean complementResult = false;
    private boolean exceptionThrown = false;
    private JRadioButton updateSourceRB;
    private JRadioButton createNewLayerRB;
    private boolean createLayer = true;
    private String categoryName = StandardCategoryNames.RESULT;
    private static String LAYER = GenericNames.SOURCE_LAYER;
    private static String ATTRIBUTE = I18N.get("ui.plugin.analysis.AttributeQueryPlugIn.Attribute");
    private static String PREDICATE = I18N.get("ui.plugin.analysis.SpatialQueryPlugIn.Relation");
    private static String VALUE = I18N.get("ui.plugin.analysis.AttributeQueryPlugIn.Value");
    private static String DIALOG_COMPLEMENT = I18N.get("ui.plugin.analysis.SpatialQueryPlugIn.Complement-Result");
    private static String UPDATE_SRC = I18N.get("ui.plugin.analysis.SpatialQueryPlugIn.Select-features-in-the-source-layer");
    private static String CREATE_LYR = I18N.get("ui.plugin.analysis.SpatialQueryPlugIn.Create-a-new-layer-for-the-results");
    private JComboBox attrComboBox;

    public AttributeQueryPlugIn() {
        this.functionNames = AttributePredicate.getNames();
    }

    public void setCategoryName(String value) {
        this.categoryName = value;
    }

    public void initialize(PlugInContext context) throws Exception {
        FeatureInstaller featureInstaller = new FeatureInstaller(context.getWorkbenchContext());
        featureInstaller.addMainMenuItem(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_QUERIES}, this.getName() + "...", false, null, AttributeQueryPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    public String getName() {
        return I18N.get("ui.plugin.analysis.AttributeQueryPlugIn.Attribute-Query");
    }

    public boolean execute(PlugInContext context) throws Exception {
        ATTR_GEOMETRY_AREA = I18N.get("ui.plugin.analysis.AttributeQueryPlugIn.Geometry.Area");
        ATTR_GEOMETRY_LENGTH = I18N.get("ui.plugin.analysis.AttributeQueryPlugIn.Geometry.Length");
        ATTR_GEOMETRY_NUMPOINTS = I18N.get("ui.plugin.analysis.AttributeQueryPlugIn.Geometry.NumPoints");
        ATTR_GEOMETRY_NUMCOMPONENTS = I18N.get("ui.plugin.analysis.AttributeQueryPlugIn.Geometry.NumComponents");
        ATTR_GEOMETRY_ISCLOSED = I18N.get("ui.plugin.analysis.AttributeQueryPlugIn.Geometry.IsClosed");
        ATTR_GEOMETRY_ISSIMPLE = I18N.get("ui.plugin.analysis.AttributeQueryPlugIn.Geometry.IsSimple");
        ATTR_GEOMETRY_ISVALID = I18N.get("ui.plugin.analysis.AttributeQueryPlugIn.Geometry.IsValid");
        ATTR_GEOMETRY_TYPE = I18N.get("ui.plugin.analysis.AttributeQueryPlugIn.Geometry.Type");
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(this.dialog, context);
        GUIUtil.centreOnWindow(this.dialog);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        if (this.srcLayer == null) {
            return false;
        }
        if (StringUtil.isEmpty(this.value)) {
            return false;
        }
        if (StringUtil.isEmpty(this.attrName)) {
            return false;
        }
        return !StringUtil.isEmpty(this.funcNameToRun);
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        monitor.report(I18N.get("ui.plugin.analysis.SpatialQueryPlugIn.Executing-query") + "...");
        FeatureCollectionWrapper sourceFC = this.srcLayer.getFeatureCollectionWrapper();
        if (monitor.isCancelRequested()) {
            return;
        }
        FeatureCollection resultFC = this.executeQuery(sourceFC, this.attrName, this.value);
        if (this.createLayer) {
            String outputLayerName = LayerNameGenerator.generateOperationOnLayerName(this.funcNameToRun, this.srcLayer.getName());
            context.getLayerManager().addCategory(this.categoryName);
            context.addLayer(this.categoryName, outputLayerName, resultFC);
        } else {
            SelectionManager selectionManager = context.getLayerViewPanel().getSelectionManager();
            selectionManager.clear();
            selectionManager.getFeatureSelection().selectItems(this.srcLayer, resultFC.getFeatures());
        }
        if (this.exceptionThrown) {
            context.getWorkbenchFrame().warnUser(I18N.get("ui.plugin.analysis.SpatialQueryPlugIn.Errors-found-while-executing-query"));
        }
    }

    private FeatureCollection executeQuery(FeatureCollection sourceFC, String attrName, String value) {
        AttributePredicate pred = AttributePredicate.getPredicate(this.funcNameToRun);
        FeatureDataset resultFC = new FeatureDataset(sourceFC.getFeatureSchema());
        Iterator i = sourceFC.iterator();
        while (i.hasNext()) {
            Feature f = (Feature)i.next();
            Object fVal = this.getValue(f, attrName);
            boolean predResult = pred.isTrue(fVal, value);
            if (this.complementResult) {
                boolean bl = predResult = !predResult;
            }
            if (!predResult) continue;
            if (this.createLayer) {
                resultFC.add(f.clone(true));
                continue;
            }
            resultFC.add(f);
        }
        return resultFC;
    }

    private Object getValue(Feature f, String attrName) {
        if (attrName == ATTR_GEOMETRY_AREA) {
            Geometry g = f.getGeometry();
            double area = g == null ? 0.0 : g.getArea();
            return new Double(area);
        }
        if (attrName == ATTR_GEOMETRY_LENGTH) {
            Geometry g = f.getGeometry();
            double len = g == null ? 0.0 : g.getLength();
            return new Double(len);
        }
        if (attrName == ATTR_GEOMETRY_NUMPOINTS) {
            Geometry g = f.getGeometry();
            double len = g == null ? 0.0 : (double)g.getNumPoints();
            return new Double(len);
        }
        if (attrName == ATTR_GEOMETRY_NUMCOMPONENTS) {
            Geometry g = f.getGeometry();
            double len = g == null ? 0.0 : (double)g.getNumGeometries();
            return new Double(len);
        }
        if (attrName == ATTR_GEOMETRY_ISCLOSED) {
            Geometry g = f.getGeometry();
            if (g instanceof LineString) {
                return new Boolean(((LineString)g).isClosed());
            }
            if (g instanceof MultiLineString) {
                return new Boolean(((MultiLineString)g).isClosed());
            }
            return new Boolean(false);
        }
        if (attrName == ATTR_GEOMETRY_ISSIMPLE) {
            Geometry g = f.getGeometry();
            boolean bool = g.isSimple();
            return new Boolean(bool);
        }
        if (attrName == ATTR_GEOMETRY_ISVALID) {
            Geometry g = f.getGeometry();
            boolean bool = g.isValid();
            return new Boolean(bool);
        }
        if (attrName == ATTR_GEOMETRY_TYPE) {
            Geometry g = f.getGeometry();
            return StringUtil.classNameWithoutQualifiers(g.getClass().getName());
        }
        return f.getAttribute(attrName);
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        LAYER = GenericNames.SOURCE_LAYER;
        ATTRIBUTE = I18N.get("ui.plugin.analysis.AttributeQueryPlugIn.Attribute");
        PREDICATE = I18N.get("ui.plugin.analysis.SpatialQueryPlugIn.Relation");
        VALUE = I18N.get("ui.plugin.analysis.AttributeQueryPlugIn.Value");
        DIALOG_COMPLEMENT = I18N.get("ui.plugin.analysis.SpatialQueryPlugIn.Complement-Result");
        UPDATE_SRC = I18N.get("ui.plugin.analysis.SpatialQueryPlugIn.Select-features-in-the-source-layer");
        CREATE_LYR = I18N.get("ui.plugin.analysis.SpatialQueryPlugIn.Create-a-new-layer-for-the-results");
        dialog.setSideBarDescription(I18N.get("ui.plugin.analysis.AttributeQueryPlugIn.Finds-the-Source-features-which-have-attribute-values-satisfying-a-given-condition"));
        Layer initLayer = this.srcLayer == null ? context.getCandidateLayer(0) : this.srcLayer;
        JComboBox lyrCombo = dialog.addLayerComboBox(LAYER, initLayer, context.getLayerManager());
        lyrCombo.addItemListener(new LayerItemListener());
        this.attrComboBox = dialog.addComboBox(ATTRIBUTE, this.attrName, this.functionNames, null);
        dialog.addComboBox(PREDICATE, this.funcNameToRun, this.functionNames, null);
        dialog.addTextField(VALUE, this.value, 20, null, null);
        dialog.addCheckBox(DIALOG_COMPLEMENT, this.complementResult);
        String OUTPUT_GROUP = "OUTPUT_GROUP";
        this.createNewLayerRB = dialog.addRadioButton(CREATE_LYR, "OUTPUT_GROUP", this.createLayer, CREATE_LYR);
        this.updateSourceRB = dialog.addRadioButton(UPDATE_SRC, "OUTPUT_GROUP", !this.createLayer, UPDATE_SRC);
        this.updateUI(initLayer);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.srcLayer = dialog.getLayer(LAYER);
        this.attrName = dialog.getText(ATTRIBUTE);
        this.funcNameToRun = dialog.getText(PREDICATE);
        this.value = dialog.getText(VALUE);
        this.complementResult = dialog.getBoolean(DIALOG_COMPLEMENT);
        this.createLayer = dialog.getBoolean(CREATE_LYR);
    }

    private void updateUI(Layer lyr) {
        List attrNames = null;
        if (lyr != null) {
            FeatureCollectionWrapper fc = lyr.getFeatureCollectionWrapper();
            FeatureSchema fs = fc.getFeatureSchema();
            attrNames = AttributeQueryPlugIn.getAttributeNames(fs);
        } else {
            attrNames = new ArrayList();
        }
        this.attrComboBox.setModel(new DefaultComboBoxModel(new Vector(attrNames)));
        this.attrComboBox.setSelectedItem(this.attrName);
    }

    private static List getAttributeNames(FeatureSchema fs) {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < fs.getAttributeCount(); ++i) {
            if (fs.getAttributeType(i) == AttributeType.GEOMETRY) continue;
            names.add(fs.getAttributeName(i));
        }
        names.add(ATTR_GEOMETRY_AREA);
        names.add(ATTR_GEOMETRY_LENGTH);
        names.add(ATTR_GEOMETRY_NUMPOINTS);
        names.add(ATTR_GEOMETRY_NUMCOMPONENTS);
        names.add(ATTR_GEOMETRY_ISCLOSED);
        names.add(ATTR_GEOMETRY_ISSIMPLE);
        names.add(ATTR_GEOMETRY_ISVALID);
        names.add(ATTR_GEOMETRY_TYPE);
        return names;
    }

    private class LayerItemListener
    implements ItemListener {
        private LayerItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            AttributeQueryPlugIn.this.updateUI((Layer)e.getItem());
        }
    }
}

