/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.analysis;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.IndexedFeatureCollection;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.ui.plugin.analysis.GeometryPredicate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SpatialJoinExecuter {
    private FeatureCollection srcAFC;
    private FeatureCollection srcBFC;
    private FeatureCollection queryFC;
    private boolean isExceptionThrown = false;
    private Geometry[] geoms = new Geometry[2];
    private Set resultSet = new HashSet();

    public SpatialJoinExecuter(FeatureCollection srcAFC, FeatureCollection srcBFC) {
        this.srcAFC = srcAFC;
        this.srcBFC = srcBFC;
    }

    private void createQueryFeatureCollection(GeometryPredicate pred) {
        boolean buildIndex = false;
        if (this.srcAFC.size() > 10) {
            buildIndex = true;
        }
        if (this.srcBFC.size() > 100) {
            buildIndex = true;
        }
        if (pred instanceof GeometryPredicate.DisjointPredicate) {
            buildIndex = false;
        }
        this.queryFC = buildIndex ? new IndexedFeatureCollection(this.srcBFC) : this.srcBFC;
    }

    private Iterator query(GeometryPredicate pred, double[] params, Geometry gMask) {
        Envelope queryEnv = gMask.getEnvelopeInternal();
        if (pred instanceof GeometryPredicate.WithinDistancePredicate) {
            queryEnv.expandBy(params[0]);
        }
        boolean useQuery = true;
        if (pred instanceof GeometryPredicate.DisjointPredicate) {
            useQuery = false;
        }
        Iterator queryIt = null;
        if (useQuery) {
            List queryResult = this.queryFC.query(queryEnv);
            queryIt = queryResult.iterator();
        } else {
            queryIt = this.queryFC.iterator();
        }
        return queryIt;
    }

    public boolean isExceptionThrown() {
        return this.isExceptionThrown;
    }

    private FeatureSchema createResultSchema() {
        FeatureSchema resultFS = new FeatureSchema();
        resultFS.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        this.copyAttributesToSchema(this.srcAFC.getFeatureSchema(), "A_", resultFS);
        this.copyAttributesToSchema(this.srcBFC.getFeatureSchema(), "B_", resultFS);
        return resultFS;
    }

    private void copyAttributesToSchema(FeatureSchema srcFS, String prefix, FeatureSchema resultFS) {
        for (int i = 0; i < srcFS.getAttributeCount(); ++i) {
            if (srcFS.getAttributeType(i) == AttributeType.GEOMETRY) continue;
            resultFS.addAttribute(prefix + srcFS.getAttributeName(i), srcFS.getAttributeType(i));
        }
    }

    public FeatureCollection getResultFC() {
        return new FeatureDataset(this.createResultSchema());
    }

    private boolean isInResult(Feature f) {
        return this.resultSet.contains(f);
    }

    public void execute(TaskMonitor monitor, GeometryPredicate func, double[] params, FeatureCollection resultFC) {
        this.createQueryFeatureCollection(func);
        int total = this.srcAFC.size();
        int count = 0;
        Iterator iMask = this.srcAFC.iterator();
        while (iMask.hasNext()) {
            monitor.report(count++, total, "features");
            if (monitor.isCancelRequested()) {
                return;
            }
            Feature fMask = (Feature)iMask.next();
            Geometry gMask = fMask.getGeometry();
            Iterator queryIt = this.query(func, params, gMask);
            while (queryIt.hasNext()) {
                Geometry gSrc;
                Feature fSrc = (Feature)queryIt.next();
                if (this.isInResult(fSrc)) continue;
                this.geoms[0] = gSrc = fSrc.getGeometry();
                this.geoms[1] = gMask;
                boolean isInResult = this.isTrue(func, gSrc, gMask, params);
                if (!isInResult) continue;
                this.addToResult(fSrc, fMask, resultFC);
            }
        }
    }

    private void addToResult(Feature fA, Feature fB, FeatureCollection resultFC) {
        BasicFeature fResult = new BasicFeature(resultFC.getFeatureSchema());
        fResult.setGeometry(fA.getGeometry());
        this.copyAttributesToFeature(fA, "B_", fResult);
        this.copyAttributesToFeature(fB, "A_", fResult);
        resultFC.add(fResult);
    }

    private void copyAttributesToFeature(Feature fSrc, String prefix, Feature fResult) {
        FeatureSchema srcFS = fSrc.getSchema();
        for (int i = 0; i < srcFS.getAttributeCount(); ++i) {
            if (srcFS.getAttributeType(i) == AttributeType.GEOMETRY) continue;
            fResult.setAttribute(prefix + srcFS.getAttributeName(i), fSrc.getAttribute(i));
        }
    }

    private boolean isTrue(GeometryPredicate func, Geometry geom0, Geometry geom1, double[] params) {
        try {
            return func.isTrue(geom0, geom1, params);
        }
        catch (RuntimeException ex) {
            this.isExceptionThrown = true;
            return false;
        }
    }
}

