/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.clipboard;

import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.CollectionOfLayerablesTransferable;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.LayerableClipboardPlugIn;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.util.Collection;
import javax.swing.JComponent;

public class PasteLayersPlugIn
extends LayerableClipboardPlugIn {
    public String getNameWithMnemonic() {
        return StringUtil.replace(this.getName(), "P", "&P", false);
    }

    public boolean execute(PlugInContext context) throws Exception {
        Transferable transferable = GUIUtil.getContents(Toolkit.getDefaultToolkit().getSystemClipboard());
        if (!transferable.isDataFlavorSupported(CollectionOfLayerablesTransferable.COLLECTION_OF_LAYERABLES_FLAVOR)) {
            return false;
        }
        Collection layerables = (Collection)transferable.getTransferData(CollectionOfLayerablesTransferable.COLLECTION_OF_LAYERABLES_FLAVOR);
        Category selectedCategory = (Category)context.getLayerNamePanel().getSelectedCategories().iterator().next();
        for (Layerable layerable : layerables) {
            Layerable clone = this.cloneLayerable(layerable);
            clone.setLayerManager(context.getLayerManager());
            context.getLayerManager().addLayerable(selectedCategory.getName(), clone);
            clone.setName(context.getLayerManager().uniqueLayerName(clone.getName()));
        }
        return true;
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNCategoriesMustBeSelectedCheck(1)).add(new EnableCheck(){

            public String check(JComponent component) {
                Transferable transferable = GUIUtil.getContents(Toolkit.getDefaultToolkit().getSystemClipboard());
                if (transferable == null) {
                    return "Clipboard must not be empty";
                }
                if (!transferable.isDataFlavorSupported(CollectionOfLayerablesTransferable.COLLECTION_OF_LAYERABLES_FLAVOR)) {
                    return "Clipboard contents must be layers";
                }
                return null;
            }
        });
    }
}

