/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.datastore;

import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.OKCancelDialog;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.ConnectionPanel;
import java.awt.Component;
import java.util.Collection;
import javax.swing.SwingUtilities;
import org.openjump.core.ui.plugin.AbstractThreadedUiPlugIn;

public abstract class AbstractAddDatastoreLayerPlugIn
extends AbstractThreadedUiPlugIn {
    private OKCancelDialog dialog;

    public boolean execute(PlugInContext context) throws Exception {
        this.panel(context).populateConnectionComboBox();
        OKCancelDialog dlg = this.getDialog(context);
        dlg.setVisible(true);
        return dlg.wasOKPressed();
    }

    public void run(TaskMonitor monitor, final PlugInContext context) throws Exception {
        final Layerable layer = this.createLayerable(this.panel(context), monitor, context);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Collection selectedCategories = context.getLayerNamePanel().getSelectedCategories();
                context.getLayerManager().addLayerable(selectedCategories.isEmpty() ? StandardCategoryNames.WORKING : selectedCategories.iterator().next().toString(), layer);
            }
        });
    }

    protected abstract Layerable createLayerable(ConnectionPanel var1, TaskMonitor var2, PlugInContext var3) throws Exception;

    protected OKCancelDialog getDialog(PlugInContext context) {
        if (this.dialog == null) {
            this.dialog = this.createDialog(context);
        }
        return this.dialog;
    }

    protected ConnectionPanel panel(PlugInContext context) {
        return (ConnectionPanel)this.getDialog(context).getCustomComponent();
    }

    private OKCancelDialog createDialog(PlugInContext context) {
        OKCancelDialog dialog = new OKCancelDialog(context.getWorkbenchFrame(), this.getName(), true, (Component)this.createPanel(context), new OKCancelDialog.Validator(){

            public String validateInput(Component component) {
                return ((ConnectionPanel)component).validateInput();
            }
        });
        dialog.pack();
        GUIUtil.centreOnWindow(dialog);
        return dialog;
    }

    protected abstract ConnectionPanel createPanel(PlugInContext var1);
}

