/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.datastore;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jump.datastore.AdhocQuery;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.io.FeatureInputStream;
import com.vividsolutions.jump.io.datasource.Connection;
import com.vividsolutions.jump.io.datasource.DataSource;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import com.vividsolutions.jump.workbench.datastore.ConnectionManager;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.WorkbenchContextReference;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.PasswordPrompter;
import java.util.ArrayList;
import java.util.Collection;

public class DataStoreQueryDataSource
extends DataSource
implements WorkbenchContextReference {
    public static final String DATASET_NAME_KEY = "Dataset Name";
    public static final String SQL_QUERY_KEY = "SQL Query";
    public static final String CONNECTION_DESCRIPTOR_KEY = "Connection Descriptor";
    private WorkbenchContext context;

    public DataStoreQueryDataSource() {
    }

    public DataStoreQueryDataSource(String datasetName, String query, ConnectionDescriptor connectionDescriptor, WorkbenchContext context) {
        this.setProperties(CollectionUtil.createMap(new Object[]{DATASET_NAME_KEY, datasetName, SQL_QUERY_KEY, query, CONNECTION_DESCRIPTOR_KEY, connectionDescriptor}));
        this.setWorkbenchContext(context);
    }

    public boolean isWritable() {
        return false;
    }

    public Connection getConnection() {
        return new Connection(){

            public FeatureCollection executeQuery(String query, Collection exceptions, TaskMonitor monitor) {
                try {
                    return DataStoreQueryDataSource.this.createFeatureCollection();
                }
                catch (Exception e) {
                    exceptions.add(e);
                    return null;
                }
            }

            public FeatureCollection executeQuery(String query, TaskMonitor monitor) throws Exception {
                ArrayList exceptions = new ArrayList();
                FeatureCollection featureCollection = this.executeQuery(query, exceptions, monitor);
                if (!exceptions.isEmpty()) {
                    throw (Exception)exceptions.iterator().next();
                }
                return featureCollection;
            }

            public void executeUpdate(String query, FeatureCollection featureCollection, TaskMonitor monitor) throws Exception {
                throw new UnsupportedOperationException();
            }

            public void close() {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FeatureCollection createFeatureCollection() {
        FeatureInputStream featureInputStream = null;
        FeatureDataset featureDataset = null;
        ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)this.getProperties().get(CONNECTION_DESCRIPTOR_KEY);
        String query = (String)this.getProperties().get(SQL_QUERY_KEY);
        String driver = connectionDescriptor.getDataStoreDriverClassName();
        if (driver.contains("Postgis") && query.matches("(?s).*\\$\\{[^\\{\\}]*\\}.*")) {
            query = this.expandQuery(query, this.context.createPlugInContext());
        }
        try {
            featureInputStream = ConnectionManager.instance(this.context).getOpenConnection(connectionDescriptor).execute(new AdhocQuery(query));
            featureDataset = new FeatureDataset(featureInputStream.getFeatureSchema());
            boolean i = false;
            while (featureInputStream.hasNext()) {
                featureDataset.add(featureInputStream.next());
            }
            FeatureDataset featureDataset2 = featureDataset;
            return featureDataset2;
        }
        catch (Exception e) {
            this.context.getWorkbench().getFrame().handleThrowable(e);
        }
        finally {
            if (featureInputStream != null) {
                try {
                    featureInputStream.close();
                }
                catch (Exception e) {}
            }
        }
        return featureDataset;
    }

    public void setWorkbenchContext(WorkbenchContext context) {
        this.context = context;
        try {
            new PasswordPrompter().getOpenConnection(ConnectionManager.instance(context), (ConnectionDescriptor)this.getProperties().get(CONNECTION_DESCRIPTOR_KEY), context.getWorkbench().getFrame());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String expandQuery(String query, PlugInContext context) {
        GeometryFactory gf = new GeometryFactory();
        Geometry viewG = gf.toGeometry(context.getLayerViewPanel().getViewport().getEnvelopeInModelCoordinates());
        Geometry fenceG = context.getLayerViewPanel().getFence();
        if (viewG != null) {
            query = query.replaceAll("\\$\\{view\\}", "\\${view:-1}");
            query = query.replaceAll("\\$\\{view(?::(-?[0-9]+))\\}", "ST_GeomFromText('" + viewG.toText() + "',$1)");
        }
        if (fenceG != null) {
            query = query.replaceAll("\\$\\{fence\\}", "\\${fence:-1}");
            query = query.replaceAll("\\$\\{fence(?::(-?[0-9]+))\\}", "ST_GeomFromText('" + fenceG.toText() + "',$1)");
        } else {
            query = query.replaceAll("\\$\\{fence\\}", "\\${fence:-1}");
            query = query.replaceAll("\\$\\{fence(?::(-?[0-9]+))\\}", "ST_GeomFromText('POLYGON EMPTY',$1)");
        }
        return query;
    }
}

