/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.skin;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.OptionsDialog;
import com.vividsolutions.jump.workbench.ui.plugin.skin.LookAndFeelProxy;
import com.vividsolutions.jump.workbench.ui.plugin.skin.SkinOptionsPanel;
import java.util.ArrayList;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class InstallSkinsPlugIn
extends AbstractPlugIn {
    private static String SKINS = I18N.get("ui.plugin.skin.InstallSkinsPlugIn.skins");
    private static String DEFAULT = I18N.get("ui.plugin.skin.InstallSkinsPlugIn.default");

    private LookAndFeelProxy createProxy(final String name, final String lookAndFeelClassName) {
        return new LookAndFeelProxy(){

            public LookAndFeel getLookAndFeel() {
                try {
                    return (LookAndFeel)Class.forName(lookAndFeelClassName).newInstance();
                }
                catch (InstantiationException e) {
                    Assert.shouldNeverReachHere((String)e.toString());
                }
                catch (IllegalAccessException e) {
                    Assert.shouldNeverReachHere((String)e.toString());
                }
                catch (ClassNotFoundException e) {
                    Assert.shouldNeverReachHere((String)e.toString());
                }
                return null;
            }

            public String toString() {
                return name;
            }
        };
    }

    public void initialize(PlugInContext context) throws Exception {
        SKINS = I18N.get("ui.plugin.skin.InstallSkinsPlugIn.skins");
        DEFAULT = I18N.get("ui.plugin.skin.InstallSkinsPlugIn.default");
        ArrayList<LookAndFeelProxy> skins = new ArrayList<LookAndFeelProxy>();
        skins.add(this.createProxy(DEFAULT, UIManager.getSystemLookAndFeelClassName()));
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            skins.add(this.createProxy(info.getName(), info.getClassName()));
        }
        context.getWorkbenchContext().getWorkbench().getBlackboard().put(SkinOptionsPanel.SKINS_KEY, skins);
        OptionsDialog.instance(context.getWorkbenchContext().getWorkbench()).addTab(SKINS, new SkinOptionsPanel(context.getWorkbenchContext().getWorkbench().getBlackboard(), context.getWorkbenchFrame()));
    }
}

