/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.test;

import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.test.RandomTrianglesPlugIn;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorScheme;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingStyle;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class TestColorThemingPlugIn
extends AbstractPlugIn {
    private List cities = Arrays.asList("Alabama", "Alaska", "Arizona", "Arkansas", "California", "Colorado", "Connecticut", "Delaware", "Florida", "Georgia", "Hawaii");
    private RandomTrianglesPlugIn randomTrianglesPlugIn = new RandomTrianglesPlugIn();

    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuItemWithJava14Fix(this, new String[]{"Tools", "Test"}, this.getName(), false, null, null);
        this.randomTrianglesPlugIn.setCities(this.cities);
    }

    public boolean execute(PlugInContext context) throws Exception {
        ArrayList names = new ArrayList();
        names.addAll(ColorScheme.discreteColorSchemeNames());
        names.addAll(ColorScheme.rangeColorSchemeNames());
        Collections.reverse(names);
        for (String colorScheme : names) {
            this.execute(context, colorScheme);
        }
        return true;
    }

    private void execute(PlugInContext context, String colorSchemeName) throws ParseException, IOException {
        this.randomTrianglesPlugIn.execute(context, 500);
        Layer layer = context.getLayerManager().getLayer("Random Triangles");
        ColorScheme colorScheme = ColorScheme.create(colorSchemeName);
        layer.setName("(" + colorScheme.getColors().size() + ") " + colorSchemeName);
        HashMap<String, BasicStyle> attributeToStyleMap = new HashMap<String, BasicStyle>();
        for (String city : this.cities) {
            attributeToStyleMap.put(city, new BasicStyle(colorScheme.next()));
        }
        layer.getBasicStyle().setEnabled(false);
        ColorThemingStyle themeStyle = new ColorThemingStyle("City", attributeToStyleMap, new BasicStyle(Color.gray));
        themeStyle.setEnabled(true);
        layer.addStyle(themeStyle);
        layer.setVisible(false);
    }
}

