/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.addremove.AddRemovePanel;
import com.vividsolutions.jump.workbench.ui.addremove.DefaultAddRemoveList;
import com.vividsolutions.jump.workbench.ui.addremove.DefaultAddRemoveListModel;
import com.vividsolutions.jump.workbench.ui.renderer.style.ChoosableStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import com.vividsolutions.jump.workbench.ui.style.StylePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class DecorationStylePanel
extends JPanel
implements StylePanel {
    private AddRemovePanel addRemovePanel = new AddRemovePanel(false);
    private BorderLayout borderLayout1 = new BorderLayout();
    private Layer layer;
    private Collection choosableStyleClasses;

    public String getTitle() {
        return I18N.get("ui.style.DecorationStylePanel.decorations");
    }

    public DecorationStylePanel(Layer layer, Collection choosableStyleClasses) {
        try {
            this.layer = layer;
            this.choosableStyleClasses = choosableStyleClasses;
            this.populateAddRemovePanel(layer, choosableStyleClasses);
            this.setUpRenderer(((DefaultAddRemoveList)this.addRemovePanel.getLeftList()).getList());
            this.setUpRenderer(((DefaultAddRemoveList)this.addRemovePanel.getRightList()).getList());
            ((DefaultAddRemoveListModel)this.addRemovePanel.getLeftList().getModel()).setSorted(true);
            ((DefaultAddRemoveListModel)this.addRemovePanel.getRightList().getModel()).setSorted(true);
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setUpRenderer(JList list) {
        list.setCellRenderer(new ListCellRenderer(){
            private DefaultListCellRenderer baseRenderer = new DefaultListCellRenderer();

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                ListItem item = (ListItem)value;
                JLabel component = (JLabel)this.baseRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                component.setText(item.style.getName());
                component.setIcon(item.style.getIcon());
                return component;
            }
        });
    }

    private void clearStyles(Layer layer) {
        for (Class choosableStyleClass : this.choosableStyleClasses) {
            Style style = layer.getStyle(choosableStyleClass);
            if (style == null) continue;
            layer.removeStyle(style);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStyles() {
        boolean firingEvents = this.layer.getLayerManager().isFiringEvents();
        this.layer.getLayerManager().setFiringEvents(false);
        try {
            this.clearStyles(this.layer);
            for (ListItem item : this.addRemovePanel.getRightItems()) {
                this.layer.addStyle(item.style);
            }
        }
        finally {
            this.layer.getLayerManager().setFiringEvents(firingEvents);
        }
        this.layer.fireAppearanceChanged();
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.addRemovePanel.setLeftText(I18N.get("ui.style.DecorationStylePanel.available"));
        this.addRemovePanel.setRightText(I18N.get("ui.style.DecorationStylePanel.in-use"));
        this.add((Component)this.addRemovePanel, "Center");
    }

    private void populateAddRemovePanel(Layer layer, Collection choosableStyleClasses) {
        ArrayList<ListItem> availableItems = new ArrayList<ListItem>();
        ArrayList<ListItem> inUseItems = new ArrayList<ListItem>();
        for (Class choosableStyleClass : choosableStyleClasses) {
            ChoosableStyle choosableStyleInUse = (ChoosableStyle)layer.getStyle(choosableStyleClass);
            if (choosableStyleInUse != null) {
                inUseItems.add(new ListItem(choosableStyleInUse));
                continue;
            }
            try {
                availableItems.add(new ListItem((ChoosableStyle)choosableStyleClass.newInstance()));
            }
            catch (IllegalAccessException e) {
                Assert.shouldNeverReachHere();
            }
            catch (InstantiationException e) {
                Assert.shouldNeverReachHere();
            }
        }
        Collections.sort(availableItems);
        Collections.sort(inUseItems);
        this.addRemovePanel.getLeftList().getModel().setItems(availableItems);
        this.addRemovePanel.getRightList().getModel().setItems(inUseItems);
    }

    public String validateInput() {
        return null;
    }

    private class ListItem
    implements Comparable {
        public ChoosableStyle style;

        public ListItem(ChoosableStyle style) {
            this.style = style;
        }

        public int compareTo(Object o) {
            return this.toString().compareTo(o.toString());
        }

        public String toString() {
            return this.style.getName();
        }
    }
}

