/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.wms;

import com.vividsolutions.wms.BoundingBox;
import com.vividsolutions.wms.WMService;
import java.awt.Image;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import net.iharder.Base64;
import org.apache.log4j.Logger;

public class MapRequest {
    private static Logger LOG = Logger.getLogger(MapRequest.class);
    private WMService service;
    private int imgWidth;
    private int imgHeight;
    private List layerList;
    private BoundingBox bbox;
    private boolean transparent;
    private String format;
    private String version = "1.0.0";

    public MapRequest(WMService service) {
        this.service = service;
        this.imgWidth = 100;
        this.imgHeight = 100;
        this.layerList = new ArrayList();
        this.bbox = service.getCapabilities().getTopLayer().getBoundingBox();
        this.transparent = false;
        this.format = null;
    }

    public WMService getService() {
        return this.service;
    }

    public String getFormat() {
        return this.format;
    }

    public int getImageWidth() {
        return this.imgWidth;
    }

    public int getImageHeight() {
        return this.imgHeight;
    }

    public List getLayers() {
        return Collections.unmodifiableList(this.layerList);
    }

    public BoundingBox getBoundingBox() {
        return this.bbox;
    }

    public boolean getTransparent() {
        return this.transparent;
    }

    public void setFormat(String format) throws IllegalArgumentException {
        this.format = format;
    }

    public void setImageWidth(int imageWidth) {
        this.imgWidth = imageWidth;
    }

    public void setImageHeight(int imageHeight) {
        this.imgHeight = imageHeight;
    }

    public void setImageSize(int imageWidth, int imageHeight) {
        this.imgWidth = imageWidth;
        this.imgHeight = imageHeight;
    }

    public void setLayers(List layerList) {
        this.layerList = layerList;
    }

    public void setBoundingBox(BoundingBox bbox) {
        this.bbox = bbox;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    public static String listToString(List list) {
        Iterator it = list.iterator();
        StringBuffer buf = new StringBuffer();
        while (it.hasNext()) {
            String layer = (String)it.next();
            buf.append(layer);
            if (!it.hasNext()) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    public URL getURL() throws MalformedURLException {
        StringBuffer urlBuf = new StringBuffer();
        String ver = "REQUEST=map&WMTVER=1.0";
        if ("1.1.0".equals(this.version)) {
            ver = "REQUEST=GetMap&SERVICE=WMS&VERSION=1.1.0";
        } else if ("1.1.1".equals(this.version)) {
            ver = "REQUEST=GetMap&SERVICE=WMS&VERSION=1.1.1";
        }
        urlBuf.append(this.service.getCapabilities().getGetMapURL() + ver + "&WIDTH=" + this.imgWidth + "&HEIGHT=" + this.imgHeight);
        try {
            urlBuf.append("&LAYERS=" + URLEncoder.encode(MapRequest.listToString(this.layerList), "UTF-8"));
        }
        catch (UnsupportedEncodingException e1) {
            LOG.debug((Object)"UTF8 not supported by Java version", (Throwable)e1);
        }
        if (this.transparent) {
            urlBuf.append("&TRANSPARENT=TRUE");
        }
        if (this.format != null) {
            try {
                urlBuf.append("&FORMAT=" + URLEncoder.encode(this.format, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                LOG.debug((Object)"UTF8 not supported by Java version", (Throwable)e);
            }
        }
        if (this.bbox != null) {
            urlBuf.append("&BBOX=" + this.bbox.getMinX() + "," + this.bbox.getMinY() + "," + this.bbox.getMaxX() + "," + this.bbox.getMaxY());
            if (this.bbox.getSRS() != null && !this.bbox.getSRS().equals("LatLon")) {
                urlBuf.append("&SRS=" + this.bbox.getSRS());
            }
        }
        urlBuf.append("&STYLES=");
        LOG.info((Object)urlBuf.toString());
        return new URL(urlBuf.toString());
    }

    public Image getImage() throws IOException {
        URL requestUrl = this.getURL();
        URLConnection con = requestUrl.openConnection();
        if (requestUrl.getUserInfo() != null) {
            con.setRequestProperty("Authorization", "Basic " + Base64.encodeBytes(requestUrl.getUserInfo().getBytes()));
        }
        return ImageIO.read(con.getInputStream());
    }

    public void setVersion(String ver) {
        this.version = ver;
    }
}

