/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.deejump.plugin.manager;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.Configuration;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.PlugInManager;
import de.latlon.deejump.plugin.manager.ExtensionManagerDialog;
import de.latlon.deejump.plugin.manager.ExtensionWrapper;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;

public class ExtensionHelper {
    private static Logger LOG = Logger.getLogger(ExtensionHelper.class);

    private ExtensionHelper() {
    }

    public static final void install(ExtensionManagerDialog extensionManager, WorkbenchContext workbenchContext, ExtensionWrapper ext, TaskMonitor monitor) throws Exception {
        PlugInManager manager = workbenchContext.getWorkbench().getPlugInManager();
        monitor.report(I18N.get("deejump.pluging.manager.ExtensionHelper.Downloading-resources"));
        File[] files = ExtensionHelper.downloadAndSaveResources(extensionManager.getExtensionSite(), ext, manager.getPlugInDirectory());
        URLClassLoader classLoader = new URLClassLoader(ExtensionHelper.toURLs(files));
        monitor.report(I18N.get("deejump.pluging.manager.ExtensionHelper.Loading-classes"));
        ArrayList extensionClasses = new ArrayList(10);
        for (int i = 0; i < files.length; ++i) {
            extensionClasses.addAll(ExtensionHelper.classes(new ZipFile(files[i]), classLoader));
        }
        ArrayList<Configuration> configs = new ArrayList<Configuration>();
        for (Class c : extensionClasses) {
            Configuration configuration = (Configuration)c.newInstance();
            configs.add(configuration);
        }
        monitor.report(I18N.get("deejump.pluging.manager.ExtensionHelper.Loading-extensions"));
        ExtensionHelper.loadConfigurations(configs, workbenchContext);
    }

    public static final void remove(List fileList, ExtensionWrapper ext, TaskMonitor monitor) throws Exception {
        List resourceList = ext.getResourceList();
        for (File file : fileList) {
            if (!file.isFile() || !resourceList.contains(file.getName())) continue;
            monitor.report(I18N.get("deejump.pluging.manager.ExtensionHelper.Deleting-file") + " " + file);
            boolean deleted = false;
            try {
                deleted = file.delete();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            System.out.println(I18N.get("deejump.pluging.manager.ExtensionHelper.deleted") + " '" + file + "': " + deleted);
        }
    }

    private static File[] downloadAndSaveResources(String extensionSite, ExtensionWrapper ext, File plugInDirectory) {
        ArrayList<File> fileList = new ArrayList<File>(ext.getResourceList().size());
        for (String resourceName : ext.getResourceList()) {
            try {
                URL resURL = new URL("jar:" + extensionSite + resourceName + "!/");
                JarURLConnection juc = (JarURLConnection)resURL.openConnection();
                JarFile jf = juc.getJarFile();
                Enumeration<JarEntry> enumer = jf.entries();
                String resourceFile = plugInDirectory + File.separator + resourceName;
                fileList.add(new File(resourceFile));
                FileOutputStream fos = new FileOutputStream(resourceFile);
                System.out.println(":vv " + resourceFile);
                JarOutputStream jos = new JarOutputStream(fos);
                while (enumer.hasMoreElements()) {
                    int c;
                    JarEntry je = enumer.nextElement();
                    jos.putNextEntry(new JarEntry(je));
                    InputStream in = jf.getInputStream(je);
                    while ((c = in.read()) >= 0) {
                        jos.write(c);
                    }
                    in.close();
                }
                jos.closeEntry();
                jos.close();
                fos.close();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return fileList.toArray(new File[fileList.size()]);
    }

    private static void saveRemoteResources(String extensionSite, ExtensionWrapper ext) {
        List extList = ext.getResourceList();
        for (String resource : extList) {
            try {
                URL resURL = new URL(extensionSite + "/" + ext.getCategory() + ext.getName());
                byte[] bitsAndBytes = null;
                DataInputStream dis = new DataInputStream(resURL.openStream());
                dis.readFully(bitsAndBytes);
                FileOutputStream fos = new FileOutputStream("c:\temp\ttt.jar");
                fos.write(bitsAndBytes);
                fos.close();
                dis.close();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static URL[] toURLs(File[] files) {
        URL[] urls = new URL[files.length];
        for (int i = 0; i < files.length; ++i) {
            try {
                System.out.println("path: " + files[i].getPath());
                urls[i] = new URL("jar:file:" + files[i].getPath() + "!/");
                continue;
            }
            catch (MalformedURLException e) {
                Assert.shouldNeverReachHere((String)e.toString());
            }
        }
        return urls;
    }

    private static List classes(ZipFile zipFile, ClassLoader classLoader) {
        ArrayList<Class> classes = new ArrayList<Class>();
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        while (e.hasMoreElements()) {
            Class c;
            ZipEntry entry = e.nextElement();
            if (!entry.getName().endsWith("Extension.class") && !entry.getName().endsWith("Configuration.class") || (c = ExtensionHelper.toClass(entry, classLoader)) == null) continue;
            classes.add(c);
        }
        return classes;
    }

    private static Class toClass(ZipEntry entry, ClassLoader classLoader) {
        Class<?> candidate;
        if (entry.isDirectory()) {
            return null;
        }
        if (!entry.getName().endsWith(".class")) {
            return null;
        }
        if (entry.getName().indexOf("$") != -1) {
            return null;
        }
        String className = entry.getName();
        className = className.substring(0, className.length() - ".class".length());
        className = StringUtil.replaceAll(className, "/", ".");
        try {
            candidate = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            Assert.shouldNeverReachHere((String)("Class not found: " + className + ". Refine class name algorithm."));
            return null;
        }
        catch (Throwable t) {
            LOG.error((Object)("Throwable encountered loading " + className + ":"));
            t.printStackTrace(System.out);
            return null;
        }
        return candidate;
    }

    private static void loadConfigurations(List configurations, WorkbenchContext context) throws Exception {
        for (Configuration configuration : configurations) {
            configuration.configure(new PlugInContext(context, null, null, null, null));
        }
    }
}

