/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.deejump.plugin.manager;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.Extension;
import com.vividsolutions.jump.workbench.plugin.PlugInManager;
import de.latlon.deejump.plugin.manager.CatalogParser;
import de.latlon.deejump.plugin.manager.ExtensionHelper;
import de.latlon.deejump.plugin.manager.ExtensionPanel;
import de.latlon.deejump.plugin.manager.ExtensionWrapper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class ExtensionManagerDialog
extends JDialog {
    private PlugInManager manager;
    private WorkbenchContext workbenchContext;
    private List remoteExtensions;
    private List installedExtensions;
    private JTextArea descripTextArea;
    private static final String extensionCatalogFile = "extensioncatalog.xml";
    private String extensionSite;
    private boolean okClicked = false;
    private final MouseListener descriptionDisplayListener = new MouseAdapter(){

        public void mouseEntered(MouseEvent e) {
            ExtensionPanel cep = (ExtensionPanel)e.getSource();
            ExtensionManagerDialog.this.setDescriptionText(cep.getExtensionText());
        }
    };
    private JPanel managePanel;
    private JPanel installPanel;
    private JPanel newVersionsPanel;

    public ExtensionManagerDialog(JFrame parent, WorkbenchContext workbenchContext, String extensionSite) throws Exception {
        super((Frame)parent, I18N.get("deejump.pluging.manager.ExtensionManagerDialog.Extension-Manager"));
        this.setSize(350, 500);
        this.setResizable(false);
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                ExtensionManagerDialog.this.okClicked = false;
                ExtensionManagerDialog.this.setVisible(false);
            }
        });
        this.workbenchContext = workbenchContext;
        this.manager = workbenchContext.getWorkbench().getPlugInManager();
        this.extensionSite = extensionSite;
        URL catalog = new URL(this.extensionSite + extensionCatalogFile);
        this.setRemoteExtensions(this.readCatalog(catalog));
        this.setInstalledExtensions(this.listInstalledExtensions());
        this.synchronizeExtensions();
        this.initGUI();
    }

    private ExtensionManagerDialog(JFrame parent, List fakeInstalledExtensions) throws HeadlessException {
        super((Frame)parent, I18N.get("deejump.pluging.manager.ExtensionManagerDialog.Extension-Manager"));
        this.setSize(350, 500);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                ExtensionManagerDialog.this.okClicked = false;
                ExtensionManagerDialog.this.setVisible(false);
            }
        });
        this.extensionSite = "http://";
        URL catalog = ExtensionManagerDialog.class.getResource("plugincatalog.xml");
        this.setRemoteExtensions(this.readCatalog(catalog));
        this.setInstalledExtensions(fakeInstalledExtensions);
        this.synchronizeExtensions();
        this.initGUI();
        this.setVisible(true);
    }

    private void setInstalledExtensions(List installedExt) {
        this.installedExtensions = installedExt;
    }

    private void setRemoteExtensions(List remoteExt) {
        this.remoteExtensions = remoteExt;
    }

    private void initGUI() {
        BoxLayout layout = new BoxLayout(this.getContentPane(), 3);
        this.getContentPane().setLayout(layout);
        this.getContentPane().add(this.createTabbedPane());
        this.getContentPane().add(this.createTextArea());
        this.getContentPane().add(this.createButtons());
    }

    private Component createTextArea() {
        this.descripTextArea = new JTextArea();
        this.descripTextArea.setRows(6);
        this.descripTextArea.setEditable(false);
        this.descripTextArea.setLineWrap(true);
        this.descripTextArea.setWrapStyleWord(false);
        JScrollPane pane = new JScrollPane(this.descripTextArea, 20, 31);
        pane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(20, 15, 20, 15), BorderFactory.createBevelBorder(1)));
        return pane;
    }

    private void setDescriptionText(String txt) {
        this.descripTextArea.setText(txt);
        this.descripTextArea.setCaretPosition(0);
    }

    private Component createTabbedPane() {
        JTabbedPane panes = new JTabbedPane();
        panes.setBorder(BorderFactory.createEmptyBorder(10, 15, 0, 15));
        panes.setPreferredSize(new Dimension(300, 400));
        this.managePanel = new JPanel();
        this.managePanel.setLayout(new BoxLayout(this.managePanel, 3));
        JScrollPane pane = new JScrollPane(this.managePanel, 20, 31);
        panes.addTab(I18N.get("deejump.pluging.manager.ExtensionManagerDialog.Installed-Extensions"), pane);
        this.refreshExtensionsPanel(this.managePanel, this.installedExtensions, true);
        this.newVersionsPanel = new JPanel();
        panes.add(I18N.get("deejump.pluging.manager.ExtensionManagerDialog.New-Versions"), this.newVersionsPanel);
        panes.setEnabledAt(1, false);
        JComponent c = new JComponent(){

            public Dimension getMaximumSize() {
                return new Dimension(350, 200);
            }
        };
        this.installPanel = new JPanel();
        this.installPanel.setLayout(new BoxLayout(this.installPanel, 3));
        pane = new JScrollPane(this.installPanel, 20, 31);
        panes.add(I18N.get("deejump.pluging.manager.ExtensionManagerDialog.Install"), pane);
        this.refreshExtensionsPanel(this.installPanel, this.remoteExtensions, false);
        return panes;
    }

    private Component createButtons() {
        Box c = Box.createHorizontalBox();
        int bSize = 20;
        c.setBorder(BorderFactory.createEmptyBorder(bSize, bSize, bSize, bSize));
        JButton button = new JButton(I18N.get("deejump.pluging.manager.ExtensionManagerDialog.Configure"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String input = JOptionPane.showInputDialog(ExtensionManagerDialog.this, I18N.get("deejump.pluging.manager.ExtensionManagerDialog.Catalog-site-URL"), ExtensionManagerDialog.this.extensionSite);
                ExtensionManagerDialog.this.extensionSite = input != null ? input : ExtensionManagerDialog.this.extensionSite;
                ExtensionManagerDialog.this.extensionSite = ExtensionManagerDialog.this.extensionSite.endsWith("/") ? ExtensionManagerDialog.this.extensionSite : ExtensionManagerDialog.this.extensionSite + "/";
                ExtensionManagerDialog.this.reReadCatalog();
            }
        });
        c.add(button);
        c.add(Box.createHorizontalStrut(20));
        button = new JButton(I18N.get("deejump.pluging.manager.ExtensionManagerDialog.OK"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExtensionManagerDialog.this.okClicked = true;
                ExtensionManagerDialog.this.setVisible(false);
            }
        });
        c.add(button);
        c.add(Box.createHorizontalStrut(20));
        button = new JButton(I18N.get("deejump.pluging.manager.ExtensionManagerDialog.Cancel"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExtensionManagerDialog.this.okClicked = false;
                ExtensionManagerDialog.this.setVisible(false);
            }
        });
        c.add(button);
        return c;
    }

    private void reReadCatalog() {
        try {
            URL u = new URL(this.extensionSite + extensionCatalogFile);
            this.setRemoteExtensions(this.readCatalog(u));
            this.setInstalledExtensions(this.listInstalledExtensions());
            this.synchronizeExtensions();
            this.refreshExtensionsPanel(this.managePanel, this.installedExtensions, true);
            this.refreshExtensionsPanel(this.installPanel, this.remoteExtensions, false);
        }
        catch (MalformedURLException e1) {
            JOptionPane.showMessageDialog(this, I18N.get("deejump.pluging.manager.ExtensionManagerDialog.You-entered-a-malformed-URL"), I18N.get("deejump.pluging.manager.ExtensionManagerDialog.Disgraceful-Error"), 0);
        }
    }

    private List listInstalledExtensions() {
        if (this.manager == null) {
            return new ArrayList(0);
        }
        ArrayList<ExtensionWrapper> tmpInstalledExtensions = new ArrayList<ExtensionWrapper>(this.manager.getConfigurations().size());
        Iterator iter = this.manager.getConfigurations().iterator();
        while (iter.hasNext()) {
            tmpInstalledExtensions.add(this.wrapExtension((Extension)iter.next()));
        }
        return tmpInstalledExtensions;
    }

    private ExtensionWrapper wrapExtension(Extension pluggedInExt) {
        for (ExtensionWrapper remExt : this.remoteExtensions) {
            if (!remExt.getName().equals(pluggedInExt.getName())) continue;
            return remExt;
        }
        String desc = I18N.get("deejump.pluging.manager.ExtensionManagerDialog.This-extension-has-not-been-found-in-the-catalogue") + "\n" + I18N.get("deejump.pluging.manager.ExtensionManagerDialog.It-may-have-been-added-by-copying-into-the-lib/ext-directory");
        String unknownCat = I18N.get("deejump.pluging.manager.ExtensionManagerDialog.unknown-category");
        String unknownAuthor = I18N.get("deejump.pluging.manager.ExtensionManagerDialog.unknown-author");
        return new ExtensionWrapper(pluggedInExt.getName(), pluggedInExt.getName() + "(" + I18N.get("deejump.pluging.manager.ExtensionManagerDialog.uncatalogued") + ")", unknownAuthor, pluggedInExt.getVersion(), I18N.get("deejump.pluging.manager.ExtensionManagerDialog.unknown-JUMP-version"), unknownCat, desc, new ArrayList(0));
    }

    private void synchronizeExtensions() {
    }

    private void _synchronizeExtensions() {
        ArrayList tmpRemoteExtensions = new ArrayList(this.remoteExtensions);
        for (ExtensionWrapper configuration : this.installedExtensions) {
            for (ExtensionWrapper ext : this.remoteExtensions) {
                if (!configuration.getName().equals(ext.getName())) continue;
            }
        }
        this.setRemoteExtensions(tmpRemoteExtensions);
    }

    private void refreshExtensionsPanel(JComponent extensionPanel, List extensionList, boolean selected) {
        extensionPanel.removeAll();
        for (ExtensionWrapper ext : extensionList) {
            ext.setInstalled(selected);
            ExtensionPanel cep = new ExtensionPanel(ext);
            if (extensionList == this.remoteExtensions && this.installedExtensions.contains(ext)) {
                cep.setSelected(true);
                cep.setEnabled(false);
            }
            cep.addMouseListener(this.descriptionDisplayListener);
            extensionPanel.add(cep);
        }
    }

    public void updateExtensions(TaskMonitor monitor) throws Exception {
        ArrayList<ExtensionWrapper> recentlyAddedExtensions = new ArrayList<ExtensionWrapper>();
        for (ExtensionWrapper ext : this.remoteExtensions) {
            if (!ext.isInstalled() || this.installedExtensions.contains(ext)) continue;
            ExtensionHelper.install(this, this.workbenchContext, ext, monitor);
            recentlyAddedExtensions.add(ext);
        }
        this.installedExtensions.addAll(recentlyAddedExtensions);
        for (ExtensionWrapper ext : this.installedExtensions) {
            if (ext.isInstalled()) continue;
            System.out.println("must :  manager.getPlugInDirectory()");
            System.out.println("pi dir: : " + this.manager.getPlugInDirectory());
            File pluginDir = this.manager.getPlugInDirectory();
            List<File> fileList = Arrays.asList(pluginDir.listFiles());
            ExtensionHelper.remove(fileList, ext, monitor);
        }
    }

    public void setVisible(boolean vis) {
        if (vis) {
            this.okClicked = false;
            System.out.println("listInstalledExtensions(): " + this.listInstalledExtensions());
            this.refreshExtensionsPanel(this.managePanel, this.installedExtensions, true);
            this.refreshExtensionsPanel(this.installPanel, this.remoteExtensions, false);
        }
        super.setVisible(vis);
    }

    private List readCatalog(URL catalog) {
        CatalogParser catParser = new CatalogParser(catalog);
        return catParser.getExtensionList();
    }

    public static void main(String[] args) throws Exception {
        ArrayList<String> resources = new ArrayList<String>(1);
        resources.add("PrintLayoutAlpha0.1-i18n.jar");
        ArrayList<ExtensionWrapper> remoteExt = new ArrayList<ExtensionWrapper>(2);
        remoteExt.add(new ExtensionWrapper("Print Layout", " some", "ut", "123", "456", "cat", "desc", resources));
        resources.clear();
        resources.add("dummy_ext.jar");
        remoteExt.add(new ExtensionWrapper("Dummy extension", "The dummy extension", "ut", "123", "456", "cat", "desc 1", resources));
        final ExtensionManagerDialog managerDialog = new ExtensionManagerDialog(new JFrame(), remoteExt);
        managerDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                try {
                    managerDialog.updateExtensions(null);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                System.exit(0);
            }
        });
    }

    public String getExtensionSite() {
        return this.extensionSite;
    }

    public boolean isOkClicked() {
        return this.okClicked;
    }
}

