/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.deejump.plugin.style;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.FeatureUtil;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.SquareVertexStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import com.vividsolutions.jump.workbench.ui.renderer.style.VertexStyle;
import com.vividsolutions.jump.workbench.ui.style.BasicStylePanel;
import com.vividsolutions.jump.workbench.ui.style.StylePanel;
import de.latlon.deejump.plugin.style.BitmapVertexStyle;
import de.latlon.deejump.plugin.style.CircleVertexStyle;
import de.latlon.deejump.plugin.style.CrossVertexStyle;
import de.latlon.deejump.plugin.style.StarVertexStyle;
import de.latlon.deejump.plugin.style.TriangleVertexStyle;
import de.latlon.deejump.plugin.style.VertexStyleChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DeeRenderingStylePanel
extends BasicStylePanel
implements StylePanel {
    private static final long serialVersionUID = 2657390245955765563L;
    VertexStyleChooser vertexStyleChooser = new VertexStyleChooser(false);
    private Layer layer;
    JCheckBox vertexCheckBox = new JCheckBox();
    JSlider vertexSlider = new JSlider(){
        private static final long serialVersionUID = 2448805758500776691L;
        {
            this.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    DeeRenderingStylePanel.this.updateControls();
                }
            });
        }
    };
    private JPanel previewPanel = new JPanel(){
        private static final long serialVersionUID = -2316761329707400966L;
        private LayerViewPanel dummyLayerViewPanel;
        private Viewport viewport;
        private Feature feature;
        {
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createLoweredBevelBorder());
            this.setMaximumSize(new Dimension(200, 40));
            this.setMinimumSize(new Dimension(200, 40));
            this.setPreferredSize(new Dimension(200, 40));
            this.dummyLayerViewPanel = new LayerViewPanel(new LayerManager(), new LayerViewPanelContext(){

                public void setStatusMessage(String message) {
                }

                public void warnUser(String warning) {
                }

                public void handleThrowable(Throwable t) {
                }
            });
            this.viewport = new Viewport(this.dummyLayerViewPanel){
                private AffineTransform transform;
                {
                    this.transform = new AffineTransform();
                }

                public Envelope getEnvelopeInModelCoordinates() {
                    return new Envelope(0.0, 200.0, 0.0, 40.0);
                }

                public AffineTransform getModelToViewTransform() {
                    return this.transform;
                }

                public Point2D toViewPoint(Coordinate modelCoordinate) {
                    return new Point2D.Double(modelCoordinate.x, modelCoordinate.y);
                }
            };
            this.feature = this.createFeature();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paint(Style style, Graphics2D g) {
            Stroke originalStroke = g.getStroke();
            try {
                style.paint(this.feature, g, this.viewport);
            }
            catch (Exception e) {
            }
            finally {
                g.setStroke(originalStroke);
            }
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.paint(DeeRenderingStylePanel.this.getBasicStyle(), (Graphics2D)g);
            if (DeeRenderingStylePanel.this.vertexCheckBox.isSelected()) {
                VertexStyle vertexStyle = DeeRenderingStylePanel.this.getVertexStyle();
                vertexStyle.initialize(new Layer(){

                    public BasicStyle getBasicStyle() {
                        return DeeRenderingStylePanel.this.getBasicStyle();
                    }
                });
                this.paint(vertexStyle, (Graphics2D)g);
            }
        }

        private Feature createFeature() {
            try {
                return FeatureUtil.toFeature(new WKTReader().read("POLYGON ((-200 80, 100 20, 400 -40, 400 80, -200 80))"), new FeatureSchema(){
                    private static final long serialVersionUID = -8627306219650589202L;
                    {
                        this.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
                    }
                });
            }
            catch (ParseException e) {
                Assert.shouldNeverReachHere();
                return null;
            }
        }
    };

    public DeeRenderingStylePanel() {
        this.vertexStyleChooser.sizeSlider = this.vertexSlider;
    }

    String getCurrentVertexStyle() {
        VertexStyle currentVertexStyle = this.layer.getVertexStyle();
        if (currentVertexStyle instanceof SquareVertexStyle) {
            return "SQUARE";
        }
        if (currentVertexStyle instanceof CircleVertexStyle) {
            return "CIRCLE";
        }
        if (currentVertexStyle instanceof CrossVertexStyle) {
            return "CROSS";
        }
        if (currentVertexStyle instanceof TriangleVertexStyle) {
            return "TRIANGLE";
        }
        if (currentVertexStyle instanceof StarVertexStyle) {
            return "STAR";
        }
        if (currentVertexStyle instanceof BitmapVertexStyle) {
            return "BITMAP";
        }
        return "";
    }

    protected DeeRenderingStylePanel(Blackboard blackboard, Layer layer, Blackboard persistentBlackboard) {
        super(blackboard, 21);
        this.vertexStyleChooser.setBlackboard(persistentBlackboard);
        this.vertexStyleChooser.setStylePanel(this);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(5), new JLabel("5"));
        labelTable.put(new Integer(10), new JLabel("10"));
        labelTable.put(new Integer(15), new JLabel("15"));
        labelTable.put(new Integer(20), new JLabel("20"));
        this.vertexSlider.setLabelTable(labelTable);
        this.setBasicStyle(layer.getBasicStyle());
        try {
            this.jbInit();
            this.updateControls();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setLayer(layer);
        if (layer.getVertexStyle() instanceof BitmapVertexStyle) {
            String fileName = ((BitmapVertexStyle)layer.getVertexStyle()).getFileName();
            this.vertexStyleChooser.setCurrentFileName(fileName);
        }
        this.vertexStyleChooser.setSelectedStyle(this.getCurrentVertexStyle());
    }

    public void updateControls() {
        super.updateControls();
        if (this.vertexSlider == null) {
            return;
        }
        this.vertexSlider.setEnabled(this.vertexCheckBox.isSelected());
        this.vertexStyleChooser.setEnabled(this.vertexCheckBox.isSelected());
        Enumeration e = this.vertexSlider.getLabelTable().elements();
        while (e.hasMoreElements()) {
            JLabel label = (JLabel)e.nextElement();
            label.setEnabled(this.vertexCheckBox.isSelected());
        }
        this.previewPanel.repaint();
    }

    public String getTitle() {
        return I18N.get("ui.style.RenderingStylePanel.rendering");
    }

    private void setLayer(Layer layer) {
        this.layer = layer;
        this.setSynchronizingLineColor(layer.isSynchronizingLineColor());
        this.vertexCheckBox.setSelected(layer.getVertexStyle().isEnabled());
        this.vertexSlider.setValue(layer.getVertexStyle().getSize());
        if (layer.getVertexStyle().isEnabled()) {
            this.fillCheckBox.setSelected(layer.getVertexStyle().getFilling());
        }
    }

    protected void jbInit() throws Exception {
        if (this.vertexSlider == null) {
            super.jbInit();
            return;
        }
        this.vertexCheckBox.setText(I18N.get("ui.style.RenderingStylePanel.vertices-size"));
        this.vertexCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                DeeRenderingStylePanel.this.showVerticesCheckBox_actionPerformed(e);
            }
        });
        this.vertexSlider.setMinorTickSpacing(1);
        this.vertexSlider.setMajorTickSpacing(0);
        this.vertexSlider.setPaintLabels(true);
        this.vertexSlider.setMinimum(4);
        this.vertexSlider.setValue(4);
        this.vertexSlider.setMaximum(20);
        this.vertexSlider.setSnapToTicks(true);
        this.vertexSlider.setPreferredSize(SLIDER_DIMENSION);
        this.centerPanel.add((Component)this.vertexSlider, new GridBagConstraints(1, 35, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.centerPanel.add((Component)GUIUtil.createSyncdTextField(this.vertexSlider, 3), new GridBagConstraints(2, 35, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.centerPanel.add((Component)this.vertexCheckBox, new GridBagConstraints(0, 35, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.centerPanel.add((Component)new JLabel(I18N.get("ui.style.RenderingStylePanel.preview")), new GridBagConstraints(0, 40, 3, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 0, 2), 0, 0));
        this.centerPanel.add((Component)this.previewPanel, new GridBagConstraints(0, 45, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 2, 2), 0, 0));
        this.centerPanel.add((Component)this.vertexStyleChooser, new GridBagConstraints(0, 50, 3, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 0, 2), 0, 0));
        this.vertexStyleChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                DeeRenderingStylePanel.this.changeVertexStyle();
            }
        });
        this.vertexStyleChooser.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSlider slider = (JSlider)e.getSource();
                DeeRenderingStylePanel.this.vertexSlider.setValue(slider.getValue());
            }
        });
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DeeRenderingStylePanel.this.changeVertexStyle();
            }
        };
        this.fillColorChooserPanel.addActionListener(listener);
        this.lineColorChooserPanel.addActionListener(listener);
    }

    protected void changeVertexStyle() {
        Style st = this.layer.getStyle(VertexStyle.class);
        this.layer.removeStyle(st);
        this.layer.addStyle(this.vertexStyleChooser.getSelectedStyle());
        this.previewPanel.repaint();
    }

    VertexStyle getVertexStyle() {
        VertexStyle vertexStyle = (VertexStyle)this.layer.getVertexStyle().clone();
        vertexStyle.setEnabled(this.vertexCheckBox.isSelected());
        vertexStyle.setSize(this.vertexSlider.getValue());
        vertexStyle.setFilling(this.fillCheckBox.isSelected());
        return vertexStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStyles() {
        boolean firingEvents = this.layer.getLayerManager().isFiringEvents();
        this.layer.getLayerManager().setFiringEvents(false);
        try {
            this.layer.removeStyle(this.layer.getBasicStyle());
            this.layer.addStyle(this.getBasicStyle());
            VertexStyle newVertexStyle = this.getVertexStyle();
            this.layer.removeStyle(this.layer.getVertexStyle());
            this.layer.addStyle(newVertexStyle);
            if (newVertexStyle.isEnabled()) {
                this.layer.getBasicStyle().setRenderingVertices(false);
            }
            this.layer.setSynchronizingLineColor(this.synchronizeCheckBox.isSelected());
        }
        finally {
            this.layer.getLayerManager().setFiringEvents(firingEvents);
        }
        this.layer.fireAppearanceChanged();
    }

    void showVerticesCheckBox_actionPerformed(ActionEvent e) {
        this.updateControls();
    }

    public String validateInput() {
        return null;
    }

    void showVerticesCheckBox_actionPerformed(ItemEvent e) {
        this.updateControls();
    }
}

