/*
 * Decompiled with CFR 0.152.
 */
package de.soldin.jumpcore;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.Layer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;

public class UndoableSetGeometry
extends AbstractUndoableEdit
implements Collection {
    private static final long serialVersionUID = 1L;
    private Collection actions = new Vector();
    private String name;
    private Layer layer;
    private HashMap proposed_geoms = new HashMap();
    private HashMap original_geoms = new HashMap();

    public void redo() {
        this.execute();
        super.redo();
    }

    public void undo() {
        this.unexecute();
        super.undo();
    }

    public String getPresentationName() {
        return this.getName();
    }

    public String getUndoPresentationName() {
        return this.getName();
    }

    public String getRedoPresentationName() {
        return this.getName();
    }

    public UndoableSetGeometry(Layer layer, String name) {
        this.layer = layer;
        this.name = name + " (Layer: " + layer.getName() + ")";
    }

    public UndoableSetGeometry(String name) {
        this.name = name;
    }

    public void execute() {
        if (this.layer != null) {
            ArrayList<Feature> modifiedFeatures = new ArrayList<Feature>();
            ArrayList<Object> modifiedFeaturesOldClones = new ArrayList<Object>();
            for (Feature feature : this.proposed_geoms.keySet()) {
                Geometry new_geom = (Geometry)this.proposed_geoms.get(feature);
                Geometry old_geom = feature.getGeometry();
                this.original_geoms.put(feature, old_geom);
                modifiedFeatures.add(feature);
                modifiedFeaturesOldClones.add(feature.clone());
                feature.setGeometry(new_geom);
            }
            this.refreshUI(modifiedFeatures, modifiedFeaturesOldClones);
        } else {
            for (UndoableSetGeometry transformation : this) {
                transformation.execute();
            }
        }
    }

    public void unexecute() {
        if (this.layer != null && this.original_geoms.size() > 0) {
            ArrayList<Feature> modifiedFeatures = new ArrayList<Feature>();
            ArrayList<Object> modifiedFeaturesOldClones = new ArrayList<Object>();
            for (Feature feature : this.original_geoms.keySet()) {
                Geometry new_geom = (Geometry)this.original_geoms.get(feature);
                modifiedFeatures.add(feature);
                modifiedFeaturesOldClones.add(feature.clone());
                feature.setGeometry(new_geom);
            }
            this.original_geoms.clear();
            this.refreshUI(modifiedFeatures, modifiedFeaturesOldClones);
        } else {
            for (UndoableSetGeometry transformation : this) {
                transformation.unexecute();
            }
        }
    }

    private void refreshUI(ArrayList modifiedFeatures, ArrayList modifiedFeaturesOldClones) {
        if (this.layer != null) {
            Layer.tryToInvalidateEnvelope(this.layer);
            if (!modifiedFeatures.isEmpty()) {
                this.layer.getLayerManager().fireGeometryModified(modifiedFeatures, this.layer, modifiedFeaturesOldClones);
            }
        }
    }

    public String getName() {
        String out = "";
        if (this.layer == null) {
            Iterator iter = this.actions.iterator();
            while (iter.hasNext()) {
                out = out + (out.length() > 0 ? ", " : "") + ((UndoableSetGeometry)iter.next()).getName();
            }
        }
        return this.name + ": " + out;
    }

    public void setGeom(Feature feature, Geometry geom) {
        this.proposed_geoms.put(feature, geom);
    }

    public Geometry getGeom(Feature in_feature) {
        return (Geometry)in_feature.getGeometry().clone();
    }

    public boolean add(UndoableSetGeometry t) {
        return this.actions.add(t);
    }

    public int size() {
        return this.actions.size();
    }

    public void clear() {
        this.actions.clear();
    }

    public boolean isEmpty() {
        if (this.layer == null) {
            for (Collection action : this.actions) {
                if (action.isEmpty()) continue;
                return false;
            }
            return true;
        }
        return this.proposed_geoms.isEmpty();
    }

    public Object[] toArray() {
        return this.actions.toArray();
    }

    public boolean add(Object o) {
        return this.actions.add(o);
    }

    public boolean contains(Object o) {
        return this.actions.contains(o);
    }

    public boolean remove(Object o) {
        return this.actions.remove(o);
    }

    public boolean addAll(Collection c) {
        return this.actions.addAll(c);
    }

    public boolean containsAll(Collection c) {
        return this.actions.containsAll(c);
    }

    public boolean removeAll(Collection c) {
        return this.actions.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.actions.retainAll(c);
    }

    public Iterator iterator() {
        return this.actions.iterator();
    }

    public Object[] toArray(Object[] a) {
        return this.actions.toArray(a);
    }
}

