/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.shapefile;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.RobustCGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jump.io.EndianDataInputStream;
import com.vividsolutions.jump.io.EndianDataOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import org.geotools.shapefile.InvalidShapefileException;
import org.geotools.shapefile.ShapeHandler;

public class PolygonHandler
implements ShapeHandler {
    protected static CGAlgorithms cga = new RobustCGAlgorithms();
    int myShapeType;

    public PolygonHandler() {
        this.myShapeType = 5;
    }

    public PolygonHandler(int type) throws InvalidShapefileException {
        if (type != 5 && type != 15 && type != 25) {
            throw new InvalidShapefileException("PolygonHandler constructor - expected type to be 5, 15, or 25.");
        }
        this.myShapeType = type;
    }

    public Geometry read(EndianDataInputStream file, GeometryFactory geometryFactory, int contentLength) throws IOException, InvalidShapefileException {
        int actualReadWords = 0;
        Object geom = null;
        int shapeType = file.readIntLE();
        actualReadWords += 2;
        if (shapeType == 0) {
            geom = geometryFactory.createMultiPolygon(new Polygon[0]);
        } else {
            int i;
            int i2;
            int fullLength;
            int t;
            if (shapeType != this.myShapeType) {
                throw new InvalidShapefileException("PolygonHandler.read() - got shape type " + shapeType + " but was expecting " + this.myShapeType);
            }
            file.readDoubleLE();
            file.readDoubleLE();
            file.readDoubleLE();
            file.readDoubleLE();
            actualReadWords += 16;
            int numParts = file.readIntLE();
            int numPoints = file.readIntLE();
            actualReadWords += 4;
            int[] partOffsets = new int[numParts];
            for (int i3 = 0; i3 < numParts; ++i3) {
                partOffsets[i3] = file.readIntLE();
                actualReadWords += 2;
            }
            ArrayList<LineString> shells = new ArrayList<LineString>();
            ArrayList<Object> holes = new ArrayList<Object>();
            ArrayList<Object> badRings = new ArrayList<Object>();
            Coordinate[] coords = new Coordinate[numPoints];
            for (t = 0; t < numPoints; ++t) {
                coords[t] = new Coordinate(file.readDoubleLE(), file.readDoubleLE());
                actualReadWords += 8;
            }
            if (this.myShapeType == 15) {
                file.readDoubleLE();
                file.readDoubleLE();
                actualReadWords += 8;
                for (t = 0; t < numPoints; ++t) {
                    coords[t].z = file.readDoubleLE();
                    actualReadWords += 4;
                }
            }
            if (this.myShapeType >= 15 && contentLength >= (fullLength = this.myShapeType == 15 ? 22 + 2 * numParts + 8 * numPoints + 8 + 4 * numPoints + 8 + 4 * numPoints : 22 + 2 * numParts + 8 * numPoints + 8 + 4 * numPoints)) {
                file.readDoubleLE();
                file.readDoubleLE();
                actualReadWords += 8;
                for (int t2 = 0; t2 < numPoints; ++t2) {
                    file.readDoubleLE();
                    actualReadWords += 4;
                }
            }
            int offset = 0;
            for (int part = 0; part < numParts; ++part) {
                LineString ring;
                int start = partOffsets[part];
                int finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
                int length = finish - start;
                Coordinate[] points = new Coordinate[length];
                for (int i4 = 0; i4 < length; ++i4) {
                    points[i4] = coords[offset];
                    ++offset;
                }
                if ((points.length == 0 || points.length > 3) && points[0].equals((Object)points[points.length - 1])) {
                    try {
                        ring = geometryFactory.createLinearRing(points);
                        if (CGAlgorithms.isCCW((Coordinate[])points)) {
                            holes.add(ring);
                            continue;
                        }
                        shells.add(ring);
                    }
                    catch (IllegalArgumentException iae) {
                        LineString ring2 = geometryFactory.createLineString(points);
                        badRings.add(ring2);
                    }
                    continue;
                }
                ring = geometryFactory.createLineString(points);
                badRings.add(ring);
            }
            if (shells.size() > 1 && holes.size() == 0 && (holes = this.findCWHoles(shells, geometryFactory)).size() > 0) {
                shells.removeAll(holes);
                ArrayList<Object> ccwHoles = new ArrayList<Object>(holes.size());
                for (int i5 = 0; i5 < holes.size(); ++i5) {
                    ccwHoles.add(this.reverseRing((LinearRing)holes.get(i5)));
                }
                holes = ccwHoles;
            }
            ArrayList holesForShells = new ArrayList(shells.size());
            ArrayList<LinearRing> holesWithoutShells = new ArrayList<LinearRing>();
            for (i2 = 0; i2 < shells.size(); ++i2) {
                holesForShells.add(new ArrayList());
            }
            for (i2 = 0; i2 < holes.size(); ++i2) {
                LinearRing testRing = (LinearRing)holes.get(i2);
                LinearRing minShell = null;
                Envelope minEnv = null;
                Envelope testEnv = testRing.getEnvelopeInternal();
                Coordinate testPt = testRing.getCoordinateN(0);
                for (int j = 0; j < shells.size(); ++j) {
                    LinearRing tryRing = (LinearRing)shells.get(j);
                    Envelope tryEnv = tryRing.getEnvelopeInternal();
                    if (minShell != null) {
                        minEnv = minShell.getEnvelopeInternal();
                    }
                    boolean isContained = false;
                    Coordinate[] coordList = tryRing.getCoordinates();
                    if (tryEnv.contains(testEnv)) {
                        if (CGAlgorithms.isPointInRing((Coordinate)testPt, (Coordinate[])coordList)) {
                            isContained = true;
                        }
                    }
                    if (!isContained || minShell != null && !minEnv.contains(tryEnv)) continue;
                    minShell = tryRing;
                }
                if (minShell == null) {
                    holesWithoutShells.add(testRing);
                    continue;
                }
                ((ArrayList)holesForShells.get(shells.indexOf(minShell))).add(testRing);
            }
            Polygon[] polygons = new Polygon[shells.size() + holesWithoutShells.size()];
            for (i = 0; i < shells.size(); ++i) {
                polygons[i] = geometryFactory.createPolygon((LinearRing)shells.get(i), ((ArrayList)holesForShells.get(i)).toArray(new LinearRing[0]));
            }
            for (i = 0; i < holesWithoutShells.size(); ++i) {
                polygons[shells.size() + i] = geometryFactory.createPolygon((LinearRing)holesWithoutShells.get(i), null);
                badRings.add((LinearRing)holesWithoutShells.get(i));
            }
            geom = polygons.length == 1 ? polygons[0] : geometryFactory.createMultiPolygon(polygons);
            if (badRings.size() > 0) {
                geom.setUserData((Object)geometryFactory.createMultiLineString(badRings.toArray(new LineString[0])));
            }
            holesForShells = null;
            holesWithoutShells = null;
            shells = null;
            holes = null;
        }
        while (actualReadWords < contentLength) {
            short junk = file.readShortBE();
            ++actualReadWords;
        }
        return geom;
    }

    ArrayList findCWHoles(ArrayList shells, GeometryFactory geometryFactory) {
        ArrayList<LinearRing> holesCW = new ArrayList<LinearRing>(shells.size());
        LinearRing[] noHole = new LinearRing[]{};
        for (int i = 0; i < shells.size(); ++i) {
            LinearRing iRing = (LinearRing)shells.get(i);
            Envelope iEnv = iRing.getEnvelopeInternal();
            Coordinate[] coordList = iRing.getCoordinates();
            for (int j = 0; j < shells.size(); ++j) {
                Polygon jPoly;
                Polygon iPoly;
                if (i == j) continue;
                LinearRing jRing = (LinearRing)shells.get(j);
                Envelope jEnv = jRing.getEnvelopeInternal();
                Coordinate jPt = jRing.getCoordinateN(0);
                Coordinate jPt2 = jRing.getCoordinateN(1);
                if (!iEnv.contains(jEnv) || !CGAlgorithms.isPointInRing((Coordinate)jPt, (Coordinate[])coordList) || !CGAlgorithms.isPointInRing((Coordinate)jPt2, (Coordinate[])coordList) || holesCW.contains(jRing) || !(iPoly = geometryFactory.createPolygon(iRing, noHole)).contains((Geometry)(jPoly = geometryFactory.createPolygon(jRing, noHole)))) continue;
                holesCW.add(jRing);
            }
        }
        return holesCW;
    }

    LinearRing reverseRing(LinearRing lr) {
        int numPoints = lr.getNumPoints();
        Coordinate[] newCoords = new Coordinate[numPoints];
        for (int t = 0; t < numPoints; ++t) {
            newCoords[t] = lr.getCoordinateN(numPoints - t - 1);
        }
        return new LinearRing(newCoords, new PrecisionModel(), 0);
    }

    public void write(Geometry geometry, EndianDataOutputStream file) throws IOException {
        int t;
        if (geometry.isEmpty()) {
            file.writeIntLE(0);
            return;
        }
        MultiPolygon multi = geometry instanceof MultiPolygon ? (MultiPolygon)geometry : new MultiPolygon(new Polygon[]{(Polygon)geometry}, geometry.getPrecisionModel(), geometry.getSRID());
        file.writeIntLE(this.getShapeType());
        Envelope box = multi.getEnvelopeInternal();
        file.writeDoubleLE(box.getMinX());
        file.writeDoubleLE(box.getMinY());
        file.writeDoubleLE(box.getMaxX());
        file.writeDoubleLE(box.getMaxY());
        int nrings = 0;
        for (int t2 = 0; t2 < multi.getNumGeometries(); ++t2) {
            Polygon p = (Polygon)multi.getGeometryN(t2);
            nrings = nrings + 1 + p.getNumInteriorRing();
        }
        int u = 0;
        int[] pointsPerRing = new int[nrings];
        for (int t3 = 0; t3 < multi.getNumGeometries(); ++t3) {
            Polygon p = (Polygon)multi.getGeometryN(t3);
            pointsPerRing[u] = p.getExteriorRing().getNumPoints();
            ++u;
            for (int v = 0; v < p.getNumInteriorRing(); ++v) {
                pointsPerRing[u] = p.getInteriorRingN(v).getNumPoints();
                ++u;
            }
        }
        int npoints = multi.getNumPoints();
        file.writeIntLE(nrings);
        file.writeIntLE(npoints);
        int count = 0;
        for (int t4 = 0; t4 < nrings; ++t4) {
            file.writeIntLE(count);
            count += pointsPerRing[t4];
        }
        Coordinate[] coords = multi.getCoordinates();
        int num = Array.getLength(coords);
        for (t = 0; t < num; ++t) {
            file.writeDoubleLE(coords[t].x);
            file.writeDoubleLE(coords[t].y);
        }
        if (this.myShapeType == 15) {
            double[] zExtreame = this.zMinMax((Geometry)multi);
            if (Double.isNaN(zExtreame[0])) {
                file.writeDoubleLE(0.0);
                file.writeDoubleLE(0.0);
            } else {
                file.writeDoubleLE(zExtreame[0]);
                file.writeDoubleLE(zExtreame[1]);
            }
            for (int t5 = 0; t5 < npoints; ++t5) {
                double z = coords[t5].z;
                if (Double.isNaN(z)) {
                    file.writeDoubleLE(0.0);
                    continue;
                }
                file.writeDoubleLE(z);
            }
        }
        if (this.myShapeType >= 15) {
            file.writeDoubleLE(-1.0E41);
            file.writeDoubleLE(-1.0E41);
            for (t = 0; t < npoints; ++t) {
                file.writeDoubleLE(-1.0E41);
            }
        }
    }

    public int getShapeType() {
        return this.myShapeType;
    }

    public int getLength(Geometry geometry) {
        if (geometry.isEmpty()) {
            return 2;
        }
        MultiPolygon multi = geometry instanceof MultiPolygon ? (MultiPolygon)geometry : new MultiPolygon(new Polygon[]{(Polygon)geometry}, geometry.getPrecisionModel(), geometry.getSRID());
        int nrings = 0;
        for (int t = 0; t < multi.getNumGeometries(); ++t) {
            Polygon p = (Polygon)multi.getGeometryN(t);
            nrings = nrings + 1 + p.getNumInteriorRing();
        }
        int npoints = multi.getNumPoints();
        if (this.myShapeType == 15) {
            return 22 + 2 * nrings + 8 * npoints + 4 * npoints + 8 + 4 * npoints + 8;
        }
        if (this.myShapeType == 25) {
            return 22 + 2 * nrings + 8 * npoints + 4 * npoints + 8;
        }
        return 22 + 2 * nrings + 8 * npoints;
    }

    double[] zMinMax(Geometry g) {
        double zmin = Double.NaN;
        double zmax = Double.NaN;
        boolean validZFound = false;
        Coordinate[] cs = g.getCoordinates();
        for (int t = 0; t < cs.length; ++t) {
            double z = cs[t].z;
            if (Double.isNaN(z)) continue;
            if (validZFound) {
                if (z < zmin) {
                    zmin = z;
                }
                if (!(z > zmax)) continue;
                zmax = z;
                continue;
            }
            validZFound = true;
            zmin = z;
            zmax = z;
        }
        return new double[]{zmin, zmax};
    }

    public Geometry getEmptyGeometry(GeometryFactory factory) {
        return factory.createMultiPolygon(new Polygon[0]);
    }
}

