/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.shapefile;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jump.io.EndianDataInputStream;
import com.vividsolutions.jump.io.EndianDataOutputStream;
import java.io.IOException;
import org.geotools.shapefile.PointHandler;
import org.geotools.shapefile.ShapeHandler;
import org.geotools.shapefile.Shapefile;

public class ShapefileHeader {
    private static final boolean DEBUG = false;
    private int fileCode = -1;
    public int fileLength = -1;
    private int indexLength = -1;
    private int version = -1;
    private int shapeType = -1;
    private Envelope bounds;
    private double zmin = 0.0;
    private double zmax = 0.0;

    public ShapefileHeader(EndianDataInputStream file) throws IOException {
        int i;
        this.fileCode = file.readIntBE();
        if (this.fileCode != 9994) {
            System.err.println("Sfh->WARNING filecode " + this.fileCode + " not a match for documented shapefile code " + 9994);
        }
        for (i = 0; i < 5; ++i) {
            int n = file.readIntBE();
        }
        this.fileLength = file.readIntBE();
        this.version = file.readIntLE();
        this.shapeType = file.readIntLE();
        for (i = 0; i < 4; ++i) {
            file.readDoubleLE();
        }
        file.skipBytes(32);
    }

    public ShapefileHeader(GeometryCollection geometries, int dims) throws Exception {
        ShapeHandler handle = geometries.getNumGeometries() == 0 ? new PointHandler() : Shapefile.getShapeHandler(geometries.getGeometryN(0), dims);
        int numShapes = geometries.getNumGeometries();
        this.shapeType = handle.getShapeType();
        boolean zvalues = false;
        if (this.shapeType == 11 || this.shapeType == 13 || this.shapeType == 15 || this.shapeType == 18) {
            zvalues = true;
            this.zmin = Double.MAX_VALUE;
            this.zmax = Double.MIN_VALUE;
        }
        this.version = 1000;
        this.fileCode = 9994;
        this.bounds = geometries.getEnvelopeInternal();
        this.fileLength = 0;
        for (int i = 0; i < numShapes; ++i) {
            Geometry g = geometries.getGeometryN(i);
            this.fileLength += handle.getLength(g);
            this.fileLength += 4;
            if (!zvalues) continue;
            Coordinate[] cc = g.getCoordinates();
            for (int j = 0; j < cc.length; ++j) {
                if (Double.isNaN(cc[j].z)) continue;
                if (cc[j].z < this.zmin) {
                    this.zmin = cc[j].z;
                }
                if (!(cc[j].z > this.zmax)) continue;
                this.zmax = cc[j].z;
            }
        }
        this.fileLength += 50;
        this.indexLength = 50 + 4 * numShapes;
    }

    public void setFileLength(int fileLength) {
        this.fileLength = fileLength;
    }

    public void write(EndianDataOutputStream file) throws IOException {
        int pos = 0;
        file.writeIntBE(this.fileCode);
        pos += 4;
        for (int i = 0; i < 5; ++i) {
            file.writeIntBE(0);
            pos += 4;
        }
        file.writeIntBE(this.fileLength);
        pos += 4;
        file.writeIntLE(this.version);
        pos += 4;
        file.writeIntLE(this.shapeType);
        pos += 4;
        file.writeDoubleLE(this.bounds.getMinX());
        file.writeDoubleLE(this.bounds.getMinY());
        file.writeDoubleLE(this.bounds.getMaxX());
        file.writeDoubleLE(this.bounds.getMaxY());
        pos += 32;
        file.writeDoubleLE(this.zmin);
        file.writeDoubleLE(this.zmax);
        pos += 16;
        file.writeDoubleLE(0.0);
        file.writeDoubleLE(0.0);
        pos += 8;
    }

    public void writeToIndex(EndianDataOutputStream file) throws IOException {
        int i;
        int pos = 0;
        file.writeIntBE(this.fileCode);
        pos += 4;
        for (i = 0; i < 5; ++i) {
            file.writeIntBE(0);
            pos += 4;
        }
        file.writeIntBE(this.indexLength);
        pos += 4;
        file.writeIntLE(this.version);
        pos += 4;
        file.writeIntLE(this.shapeType);
        pos += 4;
        pos += 8;
        file.writeDoubleLE(this.bounds.getMinX());
        pos += 8;
        file.writeDoubleLE(this.bounds.getMinY());
        pos += 8;
        file.writeDoubleLE(this.bounds.getMaxX());
        pos += 8;
        file.writeDoubleLE(this.bounds.getMaxY());
        for (i = 0; i < 4; ++i) {
            file.writeDoubleLE(0.0);
            pos += 8;
        }
    }

    public int getShapeType() {
        return this.shapeType;
    }

    public int getVersion() {
        return this.version;
    }

    public Envelope getBounds() {
        return this.bounds;
    }

    public String toString() {
        String res = new String("Sf-->type " + this.fileCode + " size " + this.fileLength + " version " + this.version + " Shape Type " + this.shapeType);
        return res;
    }
}

