/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.apitools;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.DriverProperties;
import com.vividsolutions.jump.io.FMEGMLReader;
import com.vividsolutions.jump.io.JMLReader;
import com.vividsolutions.jump.io.JMLWriter;
import com.vividsolutions.jump.io.ShapefileReader;
import com.vividsolutions.jump.io.ShapefileWriter;
import com.vividsolutions.jump.io.WKTReader;
import java.util.List;

public class IOTools {
    private static String getExtension(String filename) {
        int len = filename.length();
        String extension = filename.substring(len - 3, len);
        return extension;
    }

    public static FeatureCollection load(String filename) throws Exception {
        String extension = IOTools.getExtension(filename);
        if (extension.equalsIgnoreCase("SHP")) {
            return IOTools.loadShapefile(filename);
        }
        if (extension.equalsIgnoreCase("JML")) {
            return IOTools.loadJMLFile(filename);
        }
        if (extension.equalsIgnoreCase("WKT")) {
            return IOTools.loadWKT(filename);
        }
        throw new Exception("Unknown file type: " + extension);
    }

    public static FeatureCollection load(String filename, String zipFileName) throws Exception {
        String extension = IOTools.getExtension(filename);
        if (extension.equalsIgnoreCase("SHP")) {
            return IOTools.loadShapefile(filename, zipFileName);
        }
        throw new Exception("Unknown file type: " + extension);
    }

    public static FeatureCollection loadJMLFile(String filename) throws Exception {
        JMLReader rdr = new JMLReader();
        DriverProperties dp = new DriverProperties();
        dp.set("File", filename);
        return rdr.read(dp);
    }

    public static FeatureCollection loadShapefile(String filename) throws Exception {
        ShapefileReader rdr = new ShapefileReader();
        DriverProperties dp = new DriverProperties();
        dp.set("File", filename);
        return rdr.read(dp);
    }

    public static FeatureCollection loadShapefile(String filename, String zipFileName) throws Exception {
        ShapefileReader rdr = new ShapefileReader();
        DriverProperties dp = new DriverProperties();
        dp.set("File", filename);
        if (zipFileName != null) {
            dp.set("CompressedFile", zipFileName);
        }
        return rdr.read(dp);
    }

    public static FeatureCollection loadFMEGML(String filename) throws Exception {
        FMEGMLReader rdr = new FMEGMLReader();
        DriverProperties dp = new DriverProperties();
        dp.set("File", filename);
        return rdr.read(dp);
    }

    public static FeatureCollection loadWKT(String filename) throws Exception {
        WKTReader rdr = new WKTReader();
        DriverProperties dp = new DriverProperties();
        dp.set("File", filename);
        FeatureCollection fc = rdr.read(dp);
        return fc;
    }

    public static void save(FeatureCollection fc, String filename) throws Exception {
        String extension = IOTools.getExtension(filename);
        if (extension.equalsIgnoreCase("SHP")) {
            IOTools.saveShapefile(fc, filename);
            return;
        }
        if (extension.equalsIgnoreCase("JML")) {
            IOTools.saveJMLFile(fc, filename);
            return;
        }
        throw new Exception("Unknown file type: " + extension);
    }

    public static void saveShapefile(FeatureCollection fc, String filename) throws Exception {
        ShapefileWriter writer = new ShapefileWriter();
        DriverProperties dp = new DriverProperties();
        dp.set("File", filename);
        writer.write(fc, dp);
    }

    public static void saveJMLFile(FeatureCollection fc, String filename) throws Exception {
        JMLWriter writer = new JMLWriter();
        DriverProperties dp = new DriverProperties();
        dp.set("File", filename);
        writer.write(fc, dp);
    }

    public static void print(FeatureCollection fc) {
        List featList = fc.getFeatures();
        for (Feature f : featList) {
            System.out.println(f.getGeometry());
        }
    }
}

