/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.apitools.tables;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public abstract class StandardPirolTableModel
extends AbstractTableModel {
    protected Vector rows = new Vector();
    protected String[] colNames = null;

    public StandardPirolTableModel(String[] colNames) {
        this.colNames = colNames;
    }

    public int getColumnCount() {
        return this.colNames.length;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public String getColumnName(int column) {
        return this.colNames[column];
    }

    public void clearTable() {
        int numRows = this.getRowCount();
        this.rows.clear();
        if (numRows >= 1) {
            this.fireTableRowsDeleted(0, numRows - 1);
        }
    }

    public int findColumn(String columnName) {
        for (int i = 0; i < this.colNames.length; ++i) {
            if (!this.colNames[i].toLowerCase().equals(columnName.toLowerCase())) continue;
            return i;
        }
        return -1;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        ((Object[])this.rows.get((int)rowIndex))[columnIndex] = aValue;
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return ((Object[])this.rows.get(rowIndex))[columnIndex];
    }

    public abstract boolean isCellEditable(int var1, int var2);

    public abstract Class getColumnClass(int var1);

    public void addRow(Object[] newRow) {
        this.rows.add(newRow);
        this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
    }

    public String[] getColNames() {
        return this.colNames;
    }

    protected void setColNames(String[] colNames) {
        if (this.colNames.length != colNames.length) {
            this.clearTable();
        }
        this.colNames = colNames;
    }
}

