/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.attributeoperations;

import com.vividsolutions.jump.I18N;
import java.util.ArrayList;
import java.util.List;
import org.math.array.DoubleArray;
import org.math.array.StatisticSample;

public class Classifier1D {
    private static String pluginname = "classifyplot";
    public static String EQUAL_RANGE = "Equal Range";
    public static String EQUAL_NUMBER = "Equal Number/Quantiles";
    public static String MEAN_STDEV = "Mean Standard Deviation";
    public static String MAX_BREAKS = "Maximal Breaks";
    public static String JENKS_BREAKS = "Jenks Optimization";
    public static String KMEANS_OPTIMIZE = "Optimization with k-means";

    public static List getAvailableClassificationMethods() {
        EQUAL_RANGE = I18N.get("ui.renderer.style.ColorThemingStylePanel.Equal-Interval");
        EQUAL_NUMBER = I18N.get("ui.renderer.style.ColorThemingStylePanel.Quantile-Equal-Number");
        MEAN_STDEV = I18N.get("ui.renderer.style.ColorThemingStylePanel.Mean-Standard-Deviation");
        MAX_BREAKS = I18N.get("ui.renderer.style.ColorThemingStylePanel.Maximal-Breaks");
        JENKS_BREAKS = I18N.get("ui.renderer.style.ColorThemingStylePanel.Jenks-Optimal-Method");
        ArrayList<String> classifierList = new ArrayList<String>();
        classifierList.add(EQUAL_RANGE);
        classifierList.add(EQUAL_NUMBER);
        classifierList.add(MEAN_STDEV);
        classifierList.add(MAX_BREAKS);
        classifierList.add(JENKS_BREAKS);
        return classifierList;
    }

    public static double[] classifyEqualRange(double[] data, int numberClasses) {
        double[] limits = new double[numberClasses - 1];
        double min = DoubleArray.min((double[])data);
        double max = DoubleArray.max((double[])data);
        double delta = (max - min) / (double)numberClasses;
        for (int i = 0; i < limits.length; ++i) {
            limits[i] = min + delta * (double)(i + 1);
        }
        return limits;
    }

    public static double[] classifyEqualNumber(double[] data, int numberClasses) {
        double[] limits = new double[numberClasses - 1];
        int itemsPerClass = (int)Math.floor(data.length / numberClasses);
        double[] orderedItems = DoubleArray.sort((double[])data);
        for (int i = 0; i < limits.length; ++i) {
            int pos = 0 + itemsPerClass * (i + 1);
            int bias = 0;
            double border = 0.0;
            if (orderedItems[bias + pos - 1] != orderedItems[bias + pos]) {
                border = 0.5 * (orderedItems[bias + pos - 1] + orderedItems[bias + pos]);
            } else {
                int index = bias + pos;
                int nrEqualVal = 0;
                while (orderedItems[bias + pos - 1] == orderedItems[index]) {
                    ++index;
                    ++nrEqualVal;
                }
                border = 0.5 * (orderedItems[bias + pos - 1] + orderedItems[index]);
                bias += nrEqualVal;
            }
            limits[i] = border;
        }
        return limits;
    }

    public static double[] classifyMeanStandardDeviation(double[] data, int numberClasses) {
        double[] limits = new double[numberClasses - 1];
        double mean = StatisticSample.mean((double[])data);
        double std = StatisticSample.stddeviation((double[])data);
        boolean evenNumber = true;
        if ((double)numberClasses / 2.0 != Math.floor((double)numberClasses / 2.0)) {
            evenNumber = false;
        }
        int startMultiplier = -1 * (int)Math.floor((double)numberClasses / 2.0);
        if (evenNumber) {
            ++startMultiplier;
        }
        for (int i = 0; i < limits.length; ++i) {
            double border;
            limits[i] = border = mean + (double)startMultiplier * std;
            if (++startMultiplier != 0 || evenNumber) continue;
            startMultiplier = 1;
        }
        return limits;
    }

    public static double[] classifyMaxBreaks(double[] data, int numberClasses) {
        double[] limits = new double[numberClasses - 1];
        double[] sortData = DoubleArray.sort((double[])data);
        double[] deltaX = new double[data.length];
        for (int i = 0; i < sortData.length - 1; ++i) {
            deltaX[i] = sortData[i + 1] - sortData[i];
        }
        double[] unSortedLimits = new double[numberClasses - 1];
        double minX = DoubleArray.min((double[])deltaX);
        for (int i = 0; i < limits.length; ++i) {
            double maxX = DoubleArray.max((double[])deltaX);
            boolean found = false;
            int j = 0;
            while (!found) {
                if (deltaX[j] == maxX) {
                    found = true;
                    unSortedLimits[i] = 0.5 * (sortData[j] + sortData[j + 1]);
                    deltaX[j] = minX;
                    continue;
                }
                ++j;
            }
        }
        limits = DoubleArray.sort((double[])unSortedLimits);
        return limits;
    }

    public static double[] classifyNaturalBreaks(double[] data, int numberClasses) {
        double[] limits = new double[numberClasses - 1];
        if (limits.length == 0) {
            return limits;
        }
        double[] orderedItems = DoubleArray.sort((double[])data);
        int numData = data.length;
        if (numData == 0) {
            return limits;
        }
        double[][] mat1 = new double[numData + 1][numberClasses + 1];
        double[][] mat2 = new double[numData + 1][numberClasses + 1];
        for (int i = 1; i <= numberClasses; ++i) {
            mat1[1][i] = 1.0;
            mat2[1][i] = 0.0;
            for (int j = 2; j <= numData; ++j) {
                mat2[j][i] = Double.MAX_VALUE;
            }
        }
        double v = 0.0;
        for (int l = 2; l <= numData; ++l) {
            double s1 = 0.0;
            double s2 = 0.0;
            double w = 0.0;
            for (int m = 1; m <= l; ++m) {
                int i3 = l - m + 1;
                double val = orderedItems[i3 - 1];
                v = (s2 += val * val) - (s1 += val) * s1 / (w += 1.0);
                int i4 = i3 - 1;
                if (i4 == 0) continue;
                for (int j = 2; j <= numberClasses; ++j) {
                    if (!(mat2[l][j] >= v + mat2[i4][j - 1])) continue;
                    mat1[l][j] = i3;
                    mat2[l][j] = v + mat2[i4][j - 1];
                }
            }
            mat1[l][1] = 1.0;
            mat2[l][1] = v;
        }
        int k = numData;
        for (int j = numberClasses; j >= 2; --j) {
            double limit;
            int id = (int)mat1[k][j] - 2;
            limits[j - 2] = limit = 0.5 * (orderedItems[id] + orderedItems[id + 1]);
            k = (int)mat1[k][j] - 1;
        }
        return limits;
    }

    public static double[] classifyKMeansOnExistingBreaks(double[] data, int numberClasses, int initialLimitAlgorithm) {
        int maxRuns = 50;
        double[] limits = new double[numberClasses - 1];
        double[] sortedData = DoubleArray.sort((double[])data);
        double SDAM = Classifier1D.calcSDAM(sortedData);
        double[] tempLimits = new double[limits.length];
        tempLimits = initialLimitAlgorithm == 1 ? Classifier1D.classifyMaxBreaks(sortedData, numberClasses) : (initialLimitAlgorithm == 2 ? Classifier1D.classifyEqualRange(sortedData, numberClasses) : (initialLimitAlgorithm == 3 ? Classifier1D.classifyEqualNumber(sortedData, numberClasses) : (initialLimitAlgorithm == 4 ? Classifier1D.classifyMeanStandardDeviation(sortedData, numberClasses) : (initialLimitAlgorithm == 5 ? Classifier1D.classifyNaturalBreaks(sortedData, numberClasses) : Classifier1D.classifyMaxBreaks(sortedData, numberClasses)))));
        limits = tempLimits;
        double GVF = Classifier1D.calcGVF(sortedData, tempLimits, SDAM);
        ArrayList<Double> gdfVals = new ArrayList<Double>();
        gdfVals.add(new Double(GVF));
        boolean moveOn = true;
        int runs = 0;
        while (moveOn) {
            tempLimits = Classifier1D.adjustLimitsKMeans(sortedData, limits);
            double newGVF = Classifier1D.calcGVF(sortedData, tempLimits, SDAM);
            double dGVF = newGVF - GVF;
            if (dGVF > 0.0 && maxRuns > ++runs) {
                GVF = newGVF;
                limits = tempLimits;
                continue;
            }
            moveOn = false;
        }
        return limits;
    }

    public static double[] adjustLimitsKMeans(double[] data, double[] oldLimits) {
        double[] newLimits = new double[oldLimits.length];
        int numberClasses = oldLimits.length + 1;
        int[] oldClasses = Classifier1D.classifyData(data, oldLimits);
        double[] means = Classifier1D.calcClassMeans(data, oldClasses, numberClasses);
        int[] newClasses = new int[data.length];
        double[] classChange = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            double smallestDist = 0.0;
            int assignedClass = -1;
            smallestDist = Math.abs(data[i] - means[0]);
            assignedClass = 0;
            for (int j = 1; j < means.length; ++j) {
                double dist = Math.abs(data[i] - means[j]);
                if (!(dist < smallestDist)) continue;
                assignedClass = j;
                smallestDist = dist;
            }
            newClasses[i] = assignedClass;
            classChange[i] = newClasses[i] == oldClasses[i] ? 0.0 : 1.0;
        }
        double modifications = DoubleArray.sum((double[])classChange);
        if (modifications > 0.0) {
            int classPrev = newClasses[0];
            int classNext = -1;
            int limitIdx = 0;
            for (int i = 1; i < data.length; ++i) {
                classNext = newClasses[i];
                if (classPrev != classNext) {
                    newLimits[limitIdx] = 0.5 * (data[i - 1] + data[i]);
                    ++limitIdx;
                }
                classPrev = classNext;
            }
        } else {
            newLimits = oldLimits;
        }
        return newLimits;
    }

    public static int[] classifyData(double[] data, double[] limits) {
        int[] classes = new int[data.length];
        int nClasses = limits.length + 1;
        double minAll = DoubleArray.min((double[])data);
        double maxAll = DoubleArray.max((double[])data);
        double[] finalLimits = new double[limits.length + 2];
        for (int i = 0; i < limits.length; ++i) {
            finalLimits[i + 1] = limits[i];
        }
        finalLimits[0] = minAll;
        finalLimits[finalLimits.length - 1] = maxAll;
        boolean isInClass = false;
        for (int i = 0; i < data.length; ++i) {
            boolean assigned = false;
            for (int j = 0; j < nClasses; ++j) {
                isInClass = Classifier1D.isInClass(data[i], finalLimits[j], finalLimits[j + 1]);
                if (!isInClass) continue;
                classes[i] = j;
                assigned = true;
            }
            if (assigned) continue;
            classes[i] = -1;
            System.out.println("Classifier1D: could not classify point: " + i + " value:" + data[i] + " -- set class to -1");
        }
        return classes;
    }

    public static boolean isInClass(double val, double lowerBound, double upperBound) {
        boolean isInClass = false;
        if (val <= upperBound && val >= lowerBound) {
            isInClass = true;
        }
        return isInClass;
    }

    public static double calcSDAM(double[] data) {
        double meanAll = StatisticSample.mean((double[])data);
        double SDAM = 0.0;
        double sum = 0.0;
        for (int i = 0; i < data.length; ++i) {
            sum += (data[i] - meanAll) * (data[i] - meanAll);
        }
        SDAM = sum;
        return SDAM;
    }

    public static double calcSDCM(double[] data, int[] classes, double[] classMeans, int numClasses) {
        double SDCM = 0.0;
        double[] classSum = new double[numClasses];
        for (int i = 0; i < data.length; ++i) {
            int z = classes[i];
            classSum[z] = classSum[z] + (data[i] - classMeans[z]) * (data[i] - classMeans[z]);
        }
        double sum = 0.0;
        for (int i = 0; i < classSum.length; ++i) {
            sum += classSum[i];
        }
        SDCM = sum;
        return SDCM;
    }

    public static double calcGVF(double SDAM, double SDCM) {
        double gvf = (SDAM - SDCM) / SDAM;
        return gvf;
    }

    public static double calcGVF(double[] data, double[] limits, double SDAM) {
        int numberClasses = limits.length + 1;
        int[] classes = Classifier1D.classifyData(data, limits);
        double[] means = Classifier1D.calcClassMeans(data, classes, numberClasses);
        double SDCM = Classifier1D.calcSDCM(data, classes, means, numberClasses);
        double GDF = Classifier1D.calcGVF(SDAM, SDCM);
        return GDF;
    }

    public static double[] calcClassMeans(double[] data, int[] classes, int numClasses) {
        int i;
        double[] means = new double[numClasses];
        double[] sumC = new double[numClasses];
        int[] countCMembers = new int[numClasses];
        for (i = 0; i < data.length; ++i) {
            if (classes[i] == -1) continue;
            sumC[classes[i]] = sumC[classes[i]] + data[i];
            countCMembers[classes[i]] = countCMembers[classes[i]] + 1;
        }
        for (i = 0; i < means.length; ++i) {
            means[i] = sumC[i] / (double)countCMembers[i];
        }
        return means;
    }
}

