/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.geomutils.algorithm;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeometryConverter {
    public static ArrayList transformPolygonToLineStrings(Geometry polygon) {
        ArrayList<Geometry> inGeoms = new ArrayList<Geometry>();
        ArrayList<Object> lines = new ArrayList<Object>();
        GeometryFactory gf = new GeometryFactory();
        if (polygon instanceof MultiPolygon) {
            inGeoms.addAll(GeometryConverter.explodeGeomsIfMultiG(polygon));
        } else if (polygon instanceof Polygon) {
            inGeoms.add(polygon);
        } else {
            inGeoms.add(polygon);
            return inGeoms;
        }
        for (Polygon polygon2 : inGeoms) {
            lines.add(gf.createLineString(polygon2.getExteriorRing().getCoordinates()));
            if (polygon2.getNumInteriorRing() <= 0) continue;
            for (int i = 0; i < polygon2.getNumInteriorRing(); ++i) {
                lines.add(gf.createLinearRing(polygon2.getInteriorRingN(i).getCoordinates()));
            }
        }
        return lines;
    }

    public static ArrayList<Geometry> explodeGeomsIfMultiG(Geometry geom) {
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        if (geom instanceof GeometryCollection) {
            GeometryCollection multig = (GeometryCollection)geom;
            for (int i = 0; i < multig.getNumGeometries(); ++i) {
                Geometry g = multig.getGeometryN(i);
                geoms.add(g);
            }
        } else {
            geoms.add(geom);
        }
        return geoms;
    }
}

