/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.graph.pirolProject;

import com.vividsolutions.jts.geom.Envelope;
import java.util.Vector;
import org.openjump.core.graph.pirolProject.PirolPoint;

public class PirolEdge {
    public static PirolEdge KANTE_X0Y0ToX0Y1 = new PirolEdge(PirolPoint.NULLPUNKT, new PirolPoint(new double[]{0.0, 1.0}), true, true);
    public static PirolEdge KANTE_X0Y0ToX1Y0 = new PirolEdge(PirolPoint.NULLPUNKT, new PirolPoint(new double[]{1.0, 0.0}), true, true);
    protected PirolPoint anfang = null;
    protected PirolPoint ende = null;
    protected int punktIndexA = -1;
    protected int punktIndexB = -1;
    protected boolean anfangUnbegrenzt = true;
    protected boolean endeUnbegrenzt = true;
    protected boolean gueltig = true;
    protected static double infinityFaktor = Math.pow(10.0, 10.0);

    public PirolEdge(PirolPoint anfang, PirolPoint ende, boolean anfangUnbegrenzt, boolean endeUnbegrenzt) {
        this.anfang = anfang;
        this.ende = ende;
        this.anfangUnbegrenzt = anfangUnbegrenzt;
        this.endeUnbegrenzt = endeUnbegrenzt;
    }

    public PirolEdge(PirolPoint anfang, PirolPoint ende) {
        this.anfang = anfang;
        this.ende = ende;
        this.anfangUnbegrenzt = false;
        this.endeUnbegrenzt = false;
    }

    public PirolEdge(PirolPoint anfang, double steigung, double laenge) {
        this.anfang = anfang;
        double alpha = Math.atan(steigung);
        double dx = Math.cos(alpha) * laenge;
        double dy = Math.sin(alpha) * laenge;
        try {
            this.ende = new PirolPoint(new double[]{anfang.getX() + dx, anfang.getY() + dy});
        }
        catch (Exception e) {
            this.setGueltig(false);
            e.printStackTrace();
        }
        this.anfangUnbegrenzt = false;
        this.endeUnbegrenzt = false;
    }

    public static final PirolEdge shiftLine(PirolEdge lineToShift, PirolPoint shiftingVector) throws Exception {
        PirolPoint spkt = null;
        PirolPoint epkt = null;
        PirolPoint currPkt = null;
        double[] coords = new double[shiftingVector.getDimension()];
        for (int i = 0; i < 2; ++i) {
            currPkt = i == 0 ? lineToShift.getAnfang() : lineToShift.getEnde();
            for (int dim = 0; dim < coords.length; ++dim) {
                coords[dim] = currPkt.getCoordinate(dim) + shiftingVector.getCoordinate(dim);
            }
            if (i == 0) {
                spkt = new PirolPoint((double[])coords.clone());
                continue;
            }
            epkt = new PirolPoint((double[])coords.clone());
        }
        return new PirolEdge(spkt, epkt, lineToShift.isAnfangUnbegrenzt(), lineToShift.isEndeUnbegrenzt());
    }

    public void switchPoints() {
        PirolPoint tmp = this.getEnde();
        this.setEnde(this.getAnfang());
        this.setAnfang(tmp);
    }

    public static PirolEdge kreiereKanteDurchPunktInnerhalbBegrenzung(PirolPoint p, double steigung, Envelope begrenzung) throws Exception {
        PirolPoint p1 = null;
        PirolPoint p2 = null;
        if (steigung == 0.0) {
            p1 = new PirolPoint(new double[]{begrenzung.getMinX(), p.getY()});
            p2 = new PirolPoint(new double[]{begrenzung.getMaxX(), p.getY()});
        } else if (steigung == Double.POSITIVE_INFINITY) {
            p1 = new PirolPoint(new double[]{p.getX(), begrenzung.getMinY()});
            p2 = new PirolPoint(new double[]{p.getX(), begrenzung.getMaxY()});
        } else if (steigung == Double.NEGATIVE_INFINITY) {
            p2 = new PirolPoint(new double[]{p.getX(), begrenzung.getMinY()});
            p1 = new PirolPoint(new double[]{p.getX(), begrenzung.getMaxY()});
        } else {
            double minX = begrenzung.getMinX();
            double maxX = begrenzung.getMaxX();
            double minY = begrenzung.getMinY();
            double maxY = begrenzung.getMaxY();
            PirolPoint upperLeft = new PirolPoint(new double[]{minX, maxY});
            PirolPoint lowerLeft = new PirolPoint(new double[]{minX, minY});
            PirolPoint upperRight = new PirolPoint(new double[]{maxX, maxY});
            PirolPoint lowerRight = new PirolPoint(new double[]{maxX, minY});
            PirolEdge top = new PirolEdge(upperLeft, upperRight);
            PirolEdge right = new PirolEdge(upperRight, lowerRight);
            PirolEdge bottom = new PirolEdge(lowerRight, lowerLeft);
            PirolEdge left = new PirolEdge(lowerLeft, upperLeft);
            PirolEdge toBeCut = new PirolEdge(p, steigung, 5.0);
            toBeCut.setAnfangUnbegrenzt(true);
            toBeCut.setEndeUnbegrenzt(true);
            PirolEdge[] kanten = new PirolEdge[]{top, right, bottom, left};
            Vector<PirolPoint> schnittPunkte = new Vector<PirolPoint>();
            for (int i = 0; i < kanten.length; ++i) {
                PirolPoint sp = toBeCut.getSchnittpunkt(kanten[i]);
                if (sp == null) continue;
                schnittPunkte.add(sp);
            }
            if (schnittPunkte.size() == 2) {
                PirolPoint tmp1 = (PirolPoint)schnittPunkte.get(0);
                PirolPoint tmp2 = (PirolPoint)schnittPunkte.get(1);
                if (steigung > 0.0) {
                    if (tmp1.getY() < tmp2.getY()) {
                        p1 = tmp1;
                        p2 = tmp2;
                    } else {
                        p1 = tmp2;
                        p2 = tmp1;
                    }
                } else if (tmp1.getY() > tmp2.getY()) {
                    p1 = tmp1;
                    p2 = tmp2;
                } else {
                    p1 = tmp2;
                    p2 = tmp1;
                }
            }
        }
        return new PirolEdge(p1, p2);
    }

    public boolean isParallelZu(PirolEdge k) throws Exception {
        return this.isParallelZu(k, infinityFaktor);
    }

    public boolean isParallelZu(PirolEdge k, double infinityFactor) throws Exception {
        PirolPoint sp = this.getSchnittpunkt(k);
        if (sp == null) {
            return true;
        }
        double thisLaenge = this.getAnfang().distanceTo(this.getEnde());
        double andereLaenge = k.getAnfang().distanceTo(k.getEnde());
        double laenge = (thisLaenge + andereLaenge) / 2.0;
        double infiniteDistance = laenge * infinityFactor;
        return this.getAnfang().distanceTo(sp) > infiniteDistance && this.getEnde().distanceTo(sp) > infiniteDistance;
    }

    public double getSteigung() throws Exception {
        double x1 = this.getAnfang().getX();
        double x2 = this.getEnde().getX();
        double y1 = this.getAnfang().getY();
        double y2 = this.getEnde().getY();
        double deltaX = x2 - x1;
        double deltaY = y2 - y1;
        if (deltaX != 0.0) {
            return deltaY / deltaX;
        }
        if (deltaY > 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (deltaY < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        throw new Exception("wasn't able to calculate the increase of line (starting point == end point)");
    }

    public static PirolPoint getSchnittpunkt(PirolEdge k1, PirolEdge k2) throws Exception {
        PirolPoint a = k1.getAnfang();
        PirolPoint ab = new PirolPoint(new double[]{k1.getEnde().getX() - a.getX(), k1.getEnde().getY() - a.getY()});
        PirolPoint c = k2.getAnfang();
        PirolPoint cd = new PirolPoint(new double[]{k2.getEnde().getX() - c.getX(), k2.getEnde().getY() - c.getY()});
        if (a.distanceTo(k1.getEnde()) == 0.0) {
            throw new Exception("zero length!");
        }
        double m = 0.0;
        if (ab.getX() == 0.0 && cd.getX() != 0.0) {
            m = (a.getX() - c.getX()) / cd.getX();
        } else {
            if (ab.getX() == 0.0 && cd.getX() == 0.0) {
                if (a.getX() != c.getX()) {
                    return null;
                }
                if (c.getY() >= a.getY() && c.getY() <= a.getY() + ab.getY() || c.getY() <= a.getY() && c.getY() >= a.getY() + ab.getY()) {
                    return new PirolPoint(new double[]{a.getX(), c.getY()});
                }
                if (a.getY() >= c.getY() && a.getY() <= c.getY() + cd.getY() || a.getY() <= c.getY() && a.getY() >= c.getY() + cd.getY()) {
                    return new PirolPoint(new double[]{a.getX(), a.getY()});
                }
                return null;
            }
            if (ab.getY() == 0.0 && cd.getY() != 0.0) {
                m = (a.getY() - c.getY()) / cd.getY();
            } else if (ab.getX() != 0.0 && cd.getX() * ab.getY() / ab.getX() != cd.getY()) {
                m = (a.getY() - c.getY() + (c.getX() - a.getX()) * ab.getY() / ab.getX()) / (cd.getY() - cd.getX() * ab.getY() / ab.getX());
            } else {
                return null;
            }
        }
        if (!k2.isAnfangUnbegrenzt() && m <= 0.0) {
            return null;
        }
        if (!k2.isEndeUnbegrenzt() && m >= 1.0) {
            return null;
        }
        double n = 0.0;
        if (ab.getX() == 0.0 && ab.getY() != 0.0 && cd.getX() != 0.0) {
            n = (a.getY() - c.getY() - (a.getX() - c.getX()) * cd.getY() / cd.getX()) / -ab.getY();
        } else if (ab.getX() != 0.0) {
            n = (c.getX() + m * cd.getX() - a.getX()) / ab.getX();
        } else if (cd.getY() == 0.0 && ab.getY() != 0.0) {
            n = (c.getY() - a.getY()) / ab.getY();
        } else {
            return null;
        }
        if (!k1.isAnfangUnbegrenzt() && n <= 0.0) {
            return null;
        }
        if (!k1.isEndeUnbegrenzt() && n >= 1.0) {
            return null;
        }
        PirolPoint schnittpunkt = new PirolPoint(new double[]{a.getX() + n * ab.getX(), a.getY() + n * ab.getY()});
        return schnittpunkt;
    }

    public PirolPoint getSchnittpunkt(PirolEdge k2) throws Exception {
        return PirolEdge.getSchnittpunkt(this, k2);
    }

    public int vorzeichenDesNormalenFaktors(PirolPoint pkt) throws Exception {
        double fact = this.getNormalenFaktorZu(pkt);
        if (fact > 0.0) {
            return 1;
        }
        if (fact < 0.0) {
            return -1;
        }
        return 0;
    }

    public double getABFaktorZumNormalenFaktor(PirolPoint pkt) throws Exception {
        double normalenFaktor = this.getNormalenFaktorZu(pkt);
        PirolPoint a = this.getAnfang();
        PirolPoint b = this.getEnde();
        PirolPoint c = pkt;
        PirolPoint ab = new PirolPoint(new double[]{b.getX() - a.getX(), b.getY() - a.getY()});
        PirolPoint N = new PirolPoint(new double[]{ab.getY(), -ab.getX()});
        if (ab.getX() != 0.0) {
            double Xx = (c.getX() - a.getX() - normalenFaktor * N.getX()) / ab.getX();
            return Xx;
        }
        double Yx = (c.getY() - a.getY() - normalenFaktor * N.getY()) / ab.getY();
        return Yx;
    }

    public double getNormalenFaktorZu(PirolPoint pkt) throws Exception {
        PirolPoint punkt1 = this.getAnfang();
        PirolPoint punkt2 = this.getEnde();
        PirolPoint punkt3 = pkt;
        PirolPoint ab = PirolPoint.createVector(punkt1, punkt2);
        PirolPoint N = new PirolPoint(new double[]{ab.getY(), -ab.getX()});
        double ergebnis = 0.0;
        try {
            ergebnis = ab.getX() != 0.0 && ab.getY() != 0.0 ? (punkt1.getY() - punkt3.getY() - (punkt1.getX() - punkt3.getX()) * ab.getY() / ab.getX()) / (N.getX() * ab.getY() / ab.getX() - N.getY()) : (ab.getX() == 0.0 ? (punkt3.getX() - punkt1.getX()) / N.getX() : (punkt3.getY() - punkt1.getY()) / N.getY());
        }
        catch (Exception e) {
            ergebnis = 1.0;
        }
        return ergebnis;
    }

    public PirolEdge getNormalenKante(double laenge) throws Exception {
        double faktor;
        PirolPoint punkt1 = this.getAnfang();
        PirolPoint punkt2 = this.getEnde();
        PirolPoint ab = new PirolPoint(new double[]{punkt2.getX() - punkt1.getX(), punkt2.getY() - punkt1.getY()});
        PirolPoint N = new PirolPoint(new double[]{ab.getY(), -ab.getX()});
        PirolPoint nullPunkt = PirolPoint.NULLPUNKT;
        double nLaenge = nullPunkt.distanceTo(N);
        try {
            faktor = laenge / nLaenge * -1.0;
        }
        catch (Exception e) {
            faktor = -1.0;
        }
        N.setX(N.getX() * faktor);
        N.setY(N.getY() * faktor);
        PirolEdge nKante = new PirolEdge(new PirolPoint(new double[]{punkt2.getX(), punkt2.getY()}), new PirolPoint(new double[]{punkt2.getX() + N.getX(), punkt2.getY() + N.getY()}), false, false);
        return nKante;
    }

    public String toString() {
        return "Kante<" + this.punktIndexA + "," + this.punktIndexB + ">[" + this.getAnfang().toString() + "," + this.getEnde().toString() + "]";
    }

    public double getLaenge() throws Exception {
        if (this.anfang != null && this.ende != null) {
            if (this.anfangUnbegrenzt || this.isEndeUnbegrenzt()) {
                return Double.POSITIVE_INFINITY;
            }
            return this.anfang.distanceTo(this.ende);
        }
        throw new Exception(PirolEdge.class.getName() + ": Starting point or end point not specified!");
    }

    public PirolPoint getAnfang() {
        return this.anfang;
    }

    public void setAnfang(PirolPoint anfang) {
        this.anfang = anfang;
    }

    public boolean isAnfangUnbegrenzt() {
        return this.anfangUnbegrenzt;
    }

    public void setAnfangUnbegrenzt(boolean anfangUnbegrenzt) {
        this.anfangUnbegrenzt = anfangUnbegrenzt;
    }

    public PirolPoint getEnde() {
        return this.ende;
    }

    public void setEnde(PirolPoint ende) {
        this.ende = ende;
    }

    public boolean isEndeUnbegrenzt() {
        return this.endeUnbegrenzt;
    }

    public void setEndeUnbegrenzt(boolean endeUnbegrenzt) {
        this.endeUnbegrenzt = endeUnbegrenzt;
    }

    public boolean isGueltig() {
        return this.gueltig;
    }

    public void setGueltig(boolean gueltig) {
        this.gueltig = gueltig;
    }

    public int getPunktIndexA() {
        return this.punktIndexA;
    }

    public void setPunktIndexA(int punktIndexA) {
        this.punktIndexA = punktIndexA;
    }

    public int getPunktIndexB() {
        return this.punktIndexB;
    }

    public void setPunktIndexB(int punktIndexB) {
        this.punktIndexB = punktIndexB;
    }
}

