/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage.sextante.rasterWrappers;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.openjump.core.rasterimage.sextante.ISextanteLayer;
import org.openjump.core.rasterimage.sextante.ISextanteRasterLayer;
import org.openjump.core.rasterimage.sextante.rasterWrappers.GridCell;

public class GridExtent {
    double m_dXMin;
    double m_dYMin;
    double m_dXMax;
    double m_dYMax;
    double m_dCellSize = 1.0;
    int m_iNX;
    int m_iNY;

    public GridExtent() {
    }

    public GridExtent(ISextanteLayer layer) {
        this.m_dXMin = layer.getFullExtent().getMinX();
        this.m_dXMax = layer.getFullExtent().getMaxX();
        this.m_dYMin = layer.getFullExtent().getMinY();
        this.m_dYMax = layer.getFullExtent().getMaxY();
        if (layer instanceof ISextanteRasterLayer) {
            ISextanteRasterLayer rasterLayer = (ISextanteRasterLayer)layer;
            this.m_dCellSize = rasterLayer.getLayerGridExtent().getCellSize();
        }
        this.recalculateNXAndNY();
    }

    public void setXRange(double dXMin, double dXMax) {
        this.m_dXMin = Math.min(dXMin, dXMax);
        this.m_dXMax = Math.max(dXMin, dXMax);
        this.recalculateNXAndNY();
    }

    public void setYRange(double dYMin, double dYMax) {
        this.m_dYMin = Math.min(dYMin, dYMax);
        this.m_dYMax = Math.max(dYMin, dYMax);
        this.recalculateNXAndNY();
    }

    public double getCellSize() {
        return this.m_dCellSize;
    }

    public void setCellSize(double cellSize) {
        this.m_dCellSize = cellSize;
        this.recalculateNXAndNY();
    }

    public int getNX() {
        return this.m_iNX;
    }

    public int getNY() {
        return this.m_iNY;
    }

    private void recalculateNXAndNY() {
        this.m_iNY = (int)Math.floor((this.m_dYMax - this.m_dYMin) / this.m_dCellSize);
        this.m_iNX = (int)Math.floor((this.m_dXMax - this.m_dXMin) / this.m_dCellSize);
        this.m_dXMax = this.m_dXMin + this.m_dCellSize * (double)this.m_iNX;
        this.m_dYMax = this.m_dYMin + this.m_dCellSize * (double)this.m_iNY;
    }

    public double getXMin() {
        return this.m_dXMin;
    }

    public double getXMax() {
        return this.m_dXMax;
    }

    public double getYMin() {
        return this.m_dYMin;
    }

    public double getYMax() {
        return this.m_dYMax;
    }

    public double getWidth() {
        return this.m_dXMax - this.m_dXMin;
    }

    public double getHeight() {
        return this.m_dYMax - this.m_dYMin;
    }

    public boolean contains(double x, double y) {
        return x >= this.m_dXMin && x <= this.m_dXMax && y >= this.m_dYMin && y <= this.m_dYMax;
    }

    public boolean fitsIn(GridExtent extent) {
        double MIN_DIF = 1.0E-5;
        if (extent.getCellSize() != this.getCellSize()) {
            return false;
        }
        double dOffset = Math.abs(extent.getXMin() - this.getXMin());
        double dOffsetCols = dOffset / this.getCellSize();
        boolean bFitsX = dOffsetCols - Math.floor(dOffsetCols + 0.5) < 1.0E-5;
        dOffset = Math.abs(extent.getYMax() - this.getYMax());
        double dOffsetRows = dOffset / this.getCellSize();
        boolean bFitsY = Math.abs(dOffsetRows - Math.floor(dOffsetRows + 0.5)) < 1.0E-5;
        return bFitsX && bFitsY;
    }

    public boolean equals(GridExtent extent) {
        return this.m_dXMin == extent.getXMin() && this.m_dXMax == extent.getXMax() && this.m_dYMin == extent.getYMin() && this.m_dYMax == extent.getYMax() && this.m_dCellSize == extent.getCellSize();
    }

    public void addExtent(GridExtent extent) {
        this.m_dXMin = Math.min(extent.getXMin(), this.m_dXMin);
        this.m_dXMax = Math.max(extent.getXMax(), this.m_dXMax);
        this.m_dYMin = Math.min(extent.getYMin(), this.m_dYMin);
        this.m_dYMax = Math.max(extent.getYMax(), this.m_dYMax);
        this.m_dCellSize = Math.min(extent.getCellSize(), this.m_dCellSize);
        this.recalculateNXAndNY();
    }

    public GridCell getGridCoordsFromWorldCoords(Point2D pt) {
        int x = (int)Math.floor((pt.getX() - this.m_dXMin) / this.m_dCellSize);
        int y = (int)Math.floor((this.m_dYMax - pt.getY()) / this.m_dCellSize);
        GridCell cell = new GridCell(x, y, 0.0);
        return cell;
    }

    public GridCell getGridCoordsFromWorldCoords(double x, double y) {
        return this.getGridCoordsFromWorldCoords(new Point2D.Double(x, y));
    }

    public Point2D getWorldCoordsFromGridCoords(GridCell cell) {
        double x = this.m_dXMin + ((double)cell.getX() + 0.5) * this.m_dCellSize;
        double y = this.m_dYMax - ((double)cell.getY() + 0.5) * this.m_dCellSize;
        Point2D.Double pt = new Point2D.Double(x, y);
        return pt;
    }

    public Point2D getWorldCoordsFromGridCoords(int x, int y) {
        return this.getWorldCoordsFromGridCoords(new GridCell(x, y, 0.0));
    }

    public String toString() {
        String s = Double.toString(this.m_dXMin) + ", " + Double.toString(this.m_dYMin) + ", " + Double.toString(this.m_dXMax) + ", " + Double.toString(this.m_dYMax) + ", " + Double.toString(this.m_dCellSize);
        return s;
    }

    public void enlargeOneCell() {
        this.m_dYMin -= this.m_dCellSize;
        this.m_dXMin -= this.m_dCellSize;
        this.m_dXMax += this.m_dCellSize;
        this.m_dYMax += this.m_dCellSize;
        this.recalculateNXAndNY();
    }

    public Rectangle2D getAsRectangle2D() {
        Rectangle2D.Double rect = new Rectangle2D.Double();
        ((Rectangle2D)rect).setRect(this.m_dXMin, this.m_dYMin, this.m_dXMax - this.m_dXMin, this.m_dYMax - this.m_dYMin);
        return rect;
    }

    public boolean containsCell(int x, int y) {
        return x >= 0 && x < this.m_iNX && y >= 0 && y < this.m_iNY;
    }
}

