/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.io.file;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openjump.core.ui.io.file.FileLayerLoader;
import org.openjump.core.ui.io.file.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileLayerLoader
implements FileLayerLoader {
    private String description;
    private List<String> extensions = new ArrayList<String>();
    private List<Option> optionMetadata = new ArrayList<Option>();

    public AbstractFileLayerLoader(String description, List<String> extensions) {
        this.description = description;
        for (String extension : extensions) {
            this.extensions.add(extension.toLowerCase());
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Collection<String> getFileExtensions() {
        return this.extensions;
    }

    public void addOption(String name, String type, boolean required) {
        this.optionMetadata.add(new Option(name, type, required));
    }

    public void addOption(String name, String type, Object defaultValue, boolean required) {
        this.optionMetadata.add(new Option(name, type, defaultValue, required));
    }

    public boolean removeOption(String name, String type, boolean required) {
        return this.optionMetadata.remove(new Option(name, type, required));
    }

    public boolean removeOption(String name, String type, Object defaultValue, boolean required) {
        return this.optionMetadata.remove(new Option(name, type, defaultValue, required));
    }

    @Override
    public List<Option> getOptionMetadata() {
        return this.optionMetadata;
    }

    public String toString() {
        return this.description;
    }
}

