/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.io.file;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.coordsys.CoordinateSystemRegistry;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.datasource.Connection;
import com.vividsolutions.jump.io.datasource.DataSource;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.LangUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.ui.HTMLFrame;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openjump.core.ui.io.file.AbstractFileLayerLoader;
import org.openjump.core.ui.util.ExceptionUtil;
import org.openjump.core.ui.util.TaskUtil;
import org.openjump.util.UriUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceFileLayerLoader
extends AbstractFileLayerLoader {
    private Class dataSourceClass;
    private WorkbenchContext workbenchContext;

    public DataSourceFileLayerLoader(WorkbenchContext workbenchContext, Class dataSourceClass, String description, List<String> extensions) {
        super(description, extensions);
        this.workbenchContext = workbenchContext;
        this.dataSourceClass = dataSourceClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean open(TaskMonitor monitor, URI uri, Map<String, Object> options) {
        DataSource dataSource = (DataSource)LangUtil.newInstance(this.dataSourceClass);
        Map<String, Object> properties = this.toProperties(uri, options);
        dataSource.setProperties(properties);
        String name = UriUtil.getFileNameWithoutExtension(uri);
        DataSourceQuery dataSourceQuery = new DataSourceQuery(dataSource, null, name);
        ArrayList exceptions = new ArrayList();
        String layerName = dataSourceQuery.toString();
        monitor.report("Loading " + layerName + "...");
        Connection connection = dataSourceQuery.getDataSource().getConnection();
        try {
            FeatureCollection dataset = dataSourceQuery.getDataSource().installCoordinateSystem(connection.executeQuery(dataSourceQuery.getQuery(), exceptions, monitor), CoordinateSystemRegistry.instance(this.workbenchContext.getBlackboard()));
            if (dataset != null) {
                LayerManager layerManager = this.workbenchContext.getLayerManager();
                Layer layer = new Layer(layerName, layerManager.generateLayerFillColor(), dataset, layerManager);
                Category category = TaskUtil.getSelectedCategoryName(this.workbenchContext);
                layerManager.addLayerable(category.getName(), layer);
                layer.setName(layerName);
                layer.setDataSourceQuery(dataSourceQuery);
                layer.setFeatureCollectionModified(false);
            }
        }
        finally {
            connection.close();
        }
        if (!exceptions.isEmpty()) {
            WorkbenchFrame workbenchFrame = this.workbenchContext.getWorkbench().getFrame();
            HTMLFrame outputFrame = workbenchFrame.getOutputFrame();
            outputFrame.createNewDocument();
            ExceptionUtil.reportExceptions(exceptions, dataSourceQuery, workbenchFrame, outputFrame);
            workbenchFrame.warnUser(I18N.get("datasource.LoadDatasetPlugIn.problems-were-encountered"));
            return false;
        }
        return true;
    }

    protected Map<String, Object> toProperties(URI uri, Map<String, Object> options) {
        File file;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (uri.getScheme().equals("zip")) {
            file = UriUtil.getZipFile(uri);
            String compressedFile = UriUtil.getZipEntryName(uri);
            properties.put("CompressedFile", compressedFile);
        } else {
            file = new File(uri);
        }
        String filePath = file.getAbsolutePath();
        properties.put("File", filePath);
        properties.putAll(options);
        return properties;
    }
}

