/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.customize;

import bsh.util.JConsole;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.toolbox.ToolboxDialog;
import com.vividsolutions.jump.workbench.ui.toolbox.ToolboxPlugIn;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import org.apache.log4j.Logger;
import org.openjump.util.python.JUMP_GIS_Framework;
import org.openjump.util.python.ModifyGeometry;
import org.openjump.util.python.PythonInteractiveInterpreter;
import org.python.core.PySystemState;

public class PythonToolsPlugIn
extends ToolboxPlugIn {
    private static final Logger LOG = Logger.getLogger(PythonToolsPlugIn.class);
    private static String sName = "Python Console and Tools";

    public String getName() {
        return sName;
    }

    public void initialize(PlugInContext context) throws Exception {
        sName = I18N.get("org.openjump.core.ui.plugin.customize.PythonToolsPlugIn.Python-Console-and-Tools");
        FeatureInstaller featureInstaller = new FeatureInstaller(context.getWorkbenchContext());
        featureInstaller.addMainMenuItem(this, new String[]{MenuNames.CUSTOMIZE}, sName + "...", false, null, this.createEnableCheck(context.getWorkbenchContext()));
    }

    protected void initializeToolbox(ToolboxDialog toolbox) {
        JConsole console = new JConsole();
        console.setPreferredSize(new Dimension(450, 120));
        console.println(new ImageIcon(this.getClass().getResource("jython_small_c.png")));
        toolbox.getCenterPanel().add((Component)console, "Center");
        toolbox.setTitle("Jython");
        toolbox.setInitialLocation(new GUIUtil.Location(0, true, 0, true));
        toolbox.setResizable(true);
        ClassLoader classLoader = toolbox.getContext().getWorkbench().getPlugInManager().getClassLoader();
        Properties preProperties = new Properties(System.getProperties());
        String homepath = preProperties.getProperty("user.home");
        File empty = new File("");
        String sep = File.separator;
        File plugInDirectory = toolbox.getContext().getWorkbench().getPlugInManager().getPlugInDirectory();
        String jarpath = plugInDirectory.getPath();
        String startuppath = plugInDirectory.getPath() + sep + "jython" + sep;
        Properties postProperties = new Properties();
        postProperties.put("python.home", homepath);
        postProperties.put("python.path", startuppath);
        PySystemState.initialize((Properties)preProperties, (Properties)postProperties, (String[])new String[]{""}, (ClassLoader)classLoader);
        String startupfile = startuppath + "startup.py";
        PySystemState.add_extdir((String)jarpath);
        PySystemState.add_extdir((String)(jarpath + sep + "ext"));
        PythonInteractiveInterpreter interpreter = new PythonInteractiveInterpreter(console);
        interpreter.set("wc", toolbox.getContext());
        interpreter.set("toolbox", toolbox);
        interpreter.set("startuppath", startuppath);
        interpreter.exec("import sys");
        JUMP_GIS_Framework.setWorkbenchContext(toolbox.getContext());
        ModifyGeometry.setWorkbenchContext(toolbox.getContext());
        toolbox.addToolBar();
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(new JMenu(MenuNames.TOOLS));
        toolbox.setJMenuBar(jMenuBar);
        if (new File(startupfile).exists()) {
            interpreter.execfile(startupfile);
        }
        new Thread(interpreter).start();
    }

    private Icon getIcon() {
        return new ImageIcon(this.getClass().getResource("Jython.gif"));
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createTaskWindowMustBeActiveCheck());
    }
}

