/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.datastore;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.OKCancelDialog;
import com.vividsolutions.jump.workbench.ui.TitledPopupMenu;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.ConnectionPanel;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.DataStoreQueryDataSource;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.RunDatastoreQueryPanel;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.RunDatastoreQueryPlugIn;
import java.util.Collection;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.openjump.core.ui.images.IconLoader;

public class EditDataStoreQueryPlugIn
extends RunDatastoreQueryPlugIn {
    public static final ImageIcon ICON = IconLoader.icon("arrow_edit_sql.png");
    public static final String SQL_QUERY_KEY = "SQL Query";
    public static final String CONNECTION_DESCRIPTOR_KEY = "Connection Descriptor";
    protected static final int MAIN_COLUMN_WIDTH = 400;
    Map properties;

    public void initialize(PlugInContext context) throws Exception {
        WorkbenchContext workbenchContext = context.getWorkbenchContext();
        EnableCheck enableCheck = this.createEnableCheck(workbenchContext);
        FeatureInstaller installer = new FeatureInstaller(workbenchContext);
        TitledPopupMenu popupMenu = workbenchContext.getWorkbench().getFrame().getLayerNamePopupMenu();
        installer.addPopupMenuItem(popupMenu, this, new String[]{MenuNames.DATASTORE}, this.getName(), false, ICON, enableCheck);
    }

    public String getName() {
        return I18N.get("org.openjump.core.ui.plugin.datastore.EditDataStoreQueryPlugIn.Edit-datastore-query");
    }

    public boolean execute(PlugInContext context) throws Exception {
        Layer layer = context.getLayerNamePanel().getSelectedLayers()[0];
        this.properties = layer.getDataSourceQuery().getDataSource().getProperties();
        RunDatastoreQueryPanel panel = (RunDatastoreQueryPanel)this.panel(context);
        panel.populateConnectionComboBox();
        panel.setQuery((String)this.properties.get(SQL_QUERY_KEY));
        panel.setLayerName(context.getLayerManager().uniqueLayerName(layer.getName()));
        OKCancelDialog dlg = this.getDialog(context);
        dlg.setVisible(true);
        return dlg.wasOKPressed();
    }

    protected ConnectionPanel createPanel(PlugInContext context) {
        final ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)this.properties.get(CONNECTION_DESCRIPTOR_KEY);
        RunDatastoreQueryPanel panel = new RunDatastoreQueryPanel(context.getWorkbenchContext()){

            public void populateConnectionComboBox() {
                Collection descriptors = this.connectionDescriptors();
                if (!descriptors.contains(connectionDescriptor)) {
                    descriptors.add(connectionDescriptor);
                }
                this.getConnectionComboBox().setModel(new DefaultComboBoxModel<Object>(this.sortByString(descriptors.toArray())));
                this.getConnectionComboBox().setSelectedItem(connectionDescriptor);
            }
        };
        return panel;
    }

    public EnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        final WorkbenchContext wc = workbenchContext;
        EnableCheckFactory enableCheckFactory = new EnableCheckFactory(workbenchContext);
        MultiEnableCheck enableCheck = new MultiEnableCheck();
        enableCheck.add(enableCheckFactory.createWindowWithLayerManagerMustBeActiveCheck());
        enableCheck.add(enableCheckFactory.createExactlyNLayerablesMustBeSelectedCheck(1, Layerable.class));
        enableCheck.add(new EnableCheck(){

            public String check(JComponent component) {
                Layer[] selectedLayers;
                for (Layer layer : selectedLayers = wc.getLayerNamePanel().getSelectedLayers()) {
                    if (layer.getDataSourceQuery() != null && layer.getDataSourceQuery().getDataSource() instanceof DataStoreQueryDataSource) continue;
                    return I18N.get("org.openjump.core.ui.plugin.datastore.EditDataStoreQueryPlugIn.Exactly-one-datastore-query-layer-must-be-selected");
                }
                return null;
            }
        });
        return enableCheck;
    }
}

