/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edit.helpclassesselection;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.PolygonTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import org.openjump.core.ui.plugin.edit.helpclassesselection.FenceDrawingUtil;

public class DrawFenceTool
extends PolygonTool {
    private FenceDrawingUtil myfDrawingUtil;
    private PlugInContext context;

    protected DrawFenceTool(FenceDrawingUtil featureDrawingUtil, PlugInContext context) {
        this.myfDrawingUtil = featureDrawingUtil;
        this.context = context;
    }

    public static CursorTool create(LayerNamePanelProxy layerNamePanelProxy, PlugInContext context) {
        FenceDrawingUtil fDUtil = new FenceDrawingUtil(layerNamePanelProxy);
        return fDUtil.prepare(new DrawFenceTool(fDUtil, context), false);
    }

    public Icon getIcon() {
        return IconLoader.icon("");
    }

    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        if (!this.checkPolygon()) {
            return;
        }
        int count = 0;
        Layer[] selectedLayers = this.context.getLayerNamePanel().getSelectedLayers();
        for (int i = 0; i < selectedLayers.length; ++i) {
            Layer actualLayer = selectedLayers[i];
            FeatureCollection fc = this.context.getSelectedLayer(i).getFeatureCollectionWrapper().getWrappee();
            ArrayList<Feature> features = new ArrayList<Feature>();
            Iterator iter = fc.iterator();
            while (iter.hasNext()) {
                Feature element = (Feature)iter.next();
                if (this.getPolygon().disjoint(element.getGeometry())) continue;
                features.add(element);
                ++count;
            }
            this.context.getLayerViewPanel().getSelectionManager().getFeatureSelection().selectItems(actualLayer, features);
        }
        Collection myf = this.context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
        this.context.getWorkbenchFrame().setTimeMessage(I18N.get("org.openjump.core.ui.plugin.edit.helpclassesselection.DrawFenceTool.layer-items") + ": " + count + ", " + I18N.get("org.openjump.core.ui.plugin.edit.helpclassesselection.DrawFenceTool.selected-items") + ": " + myf.size());
        Enumeration<AbstractButton> buttons = this.context.getWorkbenchContext().getWorkbench().getFrame().getToolBar().getButtonGroup().getElements();
        AbstractButton myButton = buttons.nextElement();
        int j = 0;
        while (buttons.hasMoreElements()) {
            myButton = buttons.nextElement();
            if (++j != 1) continue;
            myButton.doClick();
        }
    }
}

