/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.cursortools;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.PolygonTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import de.fho.jump.pirol.utilities.plugIns.StandardPirolPlugIn;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openjump.core.apitools.LayerTools;

public class AutoCompletePolygonCursorTool
extends PolygonTool {
    static final String sAutoComplete = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.AutoCompletePolygonCursorTool.Auto-Complete-Polygon");
    static final String sCanNotAdd = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.AutoCompletePolygonCursorTool.Can-not-add-polygon");
    private static WorkbenchContext context;
    private EnableCheckFactory checkFactory;
    private FeatureDrawingUtil featureDrawingUtil;

    protected AutoCompletePolygonCursorTool(FeatureDrawingUtil featureDrawingUtil) {
        this.featureDrawingUtil = featureDrawingUtil;
    }

    public String getName() {
        return sAutoComplete;
    }

    public AutoCompletePolygonCursorTool(EnableCheckFactory checkFactory) {
        this.checkFactory = checkFactory;
        this.allowSnapping();
    }

    public static CursorTool create(LayerNamePanelProxy layerNamePanelProxy) {
        FeatureDrawingUtil featureDrawingUtil = new FeatureDrawingUtil(layerNamePanelProxy);
        return featureDrawingUtil.prepare(new AutoCompletePolygonCursorTool(featureDrawingUtil), true);
    }

    protected void gestureFinished() throws Exception {
        Geometry newGeo;
        this.reportNothingToUndoYet();
        context = this.getWorkbench().getContext();
        if (!this.checkPolygon()) {
            return;
        }
        Layer lay = LayerTools.getSelectedLayer(context.createPlugInContext());
        Feature[] featuresInFence = StandardPirolPlugIn.getFeaturesInFenceOrInLayer(context.createPlugInContext(), lay);
        Polygon poly = this.getPolygon();
        Geometry diffGeo = newGeo = poly.getGeometryN(0);
        try {
            for (int i = 0; i < featuresInFence.length; ++i) {
                diffGeo = diffGeo.difference(featuresInFence[i].getGeometry());
            }
            if (diffGeo instanceof Polygon) {
                this.featureDrawingUtil.drawRing((Polygon)diffGeo, this.isRollingBackInvalidEdits(), this, this.getPanel());
            }
        }
        catch (Exception e) {
            this.getPanel().getContext().warnUser(sCanNotAdd + " " + e);
        }
    }

    public Icon getIcon() {
        return new ImageIcon(this.getClass().getResource("AutoCompletePoly.gif"));
    }
}

