/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.cursortools;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import org.openjump.core.geomutils.Arc;
import org.openjump.core.geomutils.GeoUtils;
import org.openjump.core.geomutils.MathVector;
import org.openjump.core.ui.plugin.edittoolbox.cursortools.ConstrainedMultiClickTool;

public abstract class ConstrainedMultiClickArcTool
extends ConstrainedMultiClickTool {
    protected boolean clockwise = true;
    protected double fullAngle = 0.0;

    protected Shape getShape() throws NoninvertibleTransformException {
        if (this.coordinates.size() > 1) {
            boolean ccwQuad;
            GeneralPath path = new GeneralPath();
            Coordinate firstCoordinate = (Coordinate)this.coordinates.get(0);
            Point2D firstPoint = this.getPanel().getViewport().toViewPoint(firstCoordinate);
            path.moveTo((float)firstPoint.getX(), (float)firstPoint.getY());
            Coordinate secondCoordinate = (Coordinate)this.coordinates.get(1);
            Point2D secondPoint = this.getPanel().getViewport().toViewPoint(secondCoordinate);
            path.lineTo((float)secondPoint.getX(), (float)secondPoint.getY());
            MathVector v1 = new MathVector(secondCoordinate).vectorBetween(new MathVector(firstCoordinate));
            MathVector v2 = new MathVector(this.tentativeCoordinate).vectorBetween(new MathVector(firstCoordinate));
            double arcAngle = v1.angleDeg(v2);
            new GeoUtils();
            boolean toRight = GeoUtils.pointToRight(this.tentativeCoordinate, firstCoordinate, secondCoordinate);
            boolean cwQuad = this.fullAngle >= 0.0 && this.fullAngle <= 90.0 && this.clockwise;
            boolean bl = ccwQuad = this.fullAngle < 0.0 && this.fullAngle >= -90.0 && !this.clockwise;
            if (arcAngle <= 90.0 && (cwQuad || ccwQuad)) {
                this.clockwise = toRight;
            }
            this.fullAngle = this.fullAngle > 90.0 || this.fullAngle < -90.0 ? (this.clockwise && !toRight || !this.clockwise && toRight ? 360.0 - arcAngle : arcAngle) : arcAngle;
            if (!this.clockwise) {
                this.fullAngle = -this.fullAngle;
            }
            Arc arc = new Arc(firstCoordinate, secondCoordinate, this.fullAngle);
            CoordinateList coords = arc.getCoordinates();
            for (int i = 1; i < coords.size(); ++i) {
                Point2D nextPoint = this.getPanel().getViewport().toViewPoint((Coordinate)coords.get(i));
                path.lineTo((int)nextPoint.getX(), (int)nextPoint.getY());
            }
            return path;
        }
        return super.getShape();
    }
}

