/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.io.File;
import org.openjump.core.ui.enablecheck.BooleanPropertyEnableCheck;
import org.openjump.core.ui.images.IconLoader;
import org.openjump.core.ui.plugin.AbstractWizardPlugin;
import org.openjump.core.ui.plugin.file.OpenWizardPlugIn;
import org.openjump.core.ui.plugin.file.open.OpenFileWizard;

public class OpenFilePlugIn
extends AbstractWizardPlugin {
    private static final String KEY = OpenFilePlugIn.class.getName();
    private static final String FILE_DOES_NOT_EXIST = I18N.get(KEY + ".file-does-not-exist");

    public OpenFilePlugIn() {
        super(IconLoader.icon("folder_page.png"));
    }

    public OpenFilePlugIn(WorkbenchContext workbenchContext, File file) {
        super(file.getName(), file.getAbsolutePath());
        this.setWorkbenchContext(workbenchContext);
        File[] files = new File[]{file};
        this.enableCheck = new BooleanPropertyEnableCheck(file, "exists", true, FILE_DOES_NOT_EXIST + ": " + file.getAbsolutePath());
        OpenFileWizard openFileWizard = new OpenFileWizard(workbenchContext, files);
        this.setWizard(openFileWizard);
    }

    public OpenFilePlugIn(WorkbenchContext workbenchContext, File[] files) {
        this.setWorkbenchContext(workbenchContext);
        OpenFileWizard openFileWizard = new OpenFileWizard(workbenchContext, files);
        this.setWizard(openFileWizard);
    }

    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        FeatureInstaller featureInstaller = new FeatureInstaller(this.workbenchContext);
        featureInstaller.addMainMenuItem(new String[]{MenuNames.FILE}, this, 2);
        OpenFileWizard openFileWizard = new OpenFileWizard(this.workbenchContext);
        this.setWizard(openFileWizard);
        OpenWizardPlugIn.addWizard(this.workbenchContext, openFileWizard);
    }
}

