/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.registry.Registry;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.WorkbenchToolBar;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import org.openjump.core.ui.images.IconLoader;
import org.openjump.core.ui.plugin.AbstractThreadedUiPlugIn;
import org.openjump.core.ui.plugin.file.open.OpenProjectWizard;
import org.openjump.core.ui.swing.wizard.WizardGroup;
import org.openjump.core.ui.swing.wizard.WizardGroupDialog;

public class OpenWizardPlugIn
extends AbstractThreadedUiPlugIn {
    private static final String KEY = OpenWizardPlugIn.class.getName();
    private WizardGroupDialog dialog;
    private WizardGroup lastWizard;

    public OpenWizardPlugIn() {
        super(I18N.get(KEY), IconLoader.icon("folder_add.png"));
    }

    public static void addWizard(WorkbenchContext workbenchContext, WizardGroup wizard) {
        Registry registry = workbenchContext.getRegistry();
        registry.createEntry(KEY, wizard);
    }

    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        JUMPWorkbench workbench = this.workbenchContext.getWorkbench();
        WorkbenchFrame frame = workbench.getFrame();
        Icon icon = this.getIcon();
        String name = this.getName();
        FeatureInstaller featureInstaller = new FeatureInstaller(this.workbenchContext);
        featureInstaller.addMainMenuItem(new String[]{MenuNames.FILE}, this, 1);
        WorkbenchToolBar toolBar = frame.getToolBar();
        toolBar.addPlugIn(1, this, icon, this.enableCheck, this.workbenchContext);
        featureInstaller.addPopupMenuItem((JPopupMenu)frame.getCategoryPopupMenu(), (PlugIn)this, name + "{pos:3}", false, icon, this.enableCheck);
    }

    public boolean execute(PlugInContext context) throws Exception {
        Registry registry = this.workbenchContext.getRegistry();
        WorkbenchFrame workbenchFrame = context.getWorkbenchFrame();
        String name = this.getName();
        if (this.dialog == null) {
            this.dialog = new WizardGroupDialog(this.workbenchContext, workbenchFrame, name);
            List wizards = registry.getEntries(KEY);
            this.lastWizard = (WizardGroup)wizards.get(0);
            for (WizardGroup wizard : wizards) {
                this.dialog.addWizard(wizard);
                if (!(wizard instanceof OpenProjectWizard)) continue;
                this.lastWizard = wizard;
            }
        }
        this.dialog.setSelectedWizard(this.lastWizard);
        this.dialog.setVisible(true);
        this.lastWizard = this.dialog.getSelectedWizard();
        return this.dialog.wasFinishPressed();
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        WizardGroup wizard = this.dialog.getSelectedWizard();
        wizard.run(this.dialog, monitor);
    }
}

