/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file.open;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.wizard.WizardDialog;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openjump.core.ui.swing.wizard.WizardGroup;
import org.openjump.core.ui.swing.wizard.WizardGroupListCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenDataTypePanel
extends JPanel
implements WizardPanel {
    public static final String KEY = OpenDataTypePanel.class.getName();
    private static final String TITLE = I18N.get(KEY);
    private static final String INSTRUCTIONS = I18N.get(KEY + ".instructions");
    private JList list;
    private Set<InputChangedListener> listeners = new LinkedHashSet<InputChangedListener>();

    public OpenDataTypePanel(WorkbenchContext workbenchContext, final WizardDialog dialog, List<WizardGroup> wizards) {
        super(new BorderLayout());
        this.list = new JList<Object>(wizards.toArray());
        this.list.setSelectionMode(0);
        this.list.setVisibleRowCount(-1);
        this.list.setLayoutOrientation(2);
        this.list.setCellRenderer(new WizardGroupListCellRenderer());
        this.list.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                for (InputChangedListener listener : OpenDataTypePanel.this.listeners) {
                    listener.inputChanged();
                }
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Rectangle bounds;
                int index;
                if (e.getClickCount() == 2 && (index = OpenDataTypePanel.this.list.locationToIndex(e.getPoint())) != -1 && (bounds = OpenDataTypePanel.this.list.getCellBounds(index, index)).contains(e.getPoint())) {
                    dialog.next();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.list);
        this.add((Component)scrollPane, "Center");
    }

    @Override
    public void add(InputChangedListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void enteredFromLeft(Map dataMap) {
    }

    @Override
    public void exitingToRight() throws Exception {
    }

    @Override
    public String getID() {
        return KEY;
    }

    @Override
    public String getInstructions() {
        return INSTRUCTIONS;
    }

    @Override
    public String getNextID() {
        WizardGroup wizard = this.getSlectedWizardGroup();
        if (wizard != null) {
            return wizard.getFirstId();
        }
        return null;
    }

    public WizardGroup getSlectedWizardGroup() {
        if (this.list.isSelectionEmpty()) {
            return null;
        }
        return (WizardGroup)this.list.getSelectedValue();
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public boolean isInputValid() {
        return !this.list.isSelectionEmpty();
    }

    @Override
    public void remove(InputChangedListener listener) {
        this.listeners.remove(listener);
    }
}

