/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openjump.io.SIDLayer;

public class AddSIDLayerPlugIn
extends AbstractPlugIn {
    static final String sAddMrSIDLayer = I18N.get("org.openjump.core.ui.plugin.layer.AddSIDLayerPlugIn.Add-MrSID-Layer");
    static final String sErrorSeeOutputWindow = I18N.get("org.openjump.core.ui.plugin.layer.AddSIDLayerPlugIn.Error-See-Output-Window");
    static final String sNotInstalled = I18N.get("org.openjump.core.ui.plugin.layer.AddSIDLayerPlugIn.not-installed");
    static final String sOpenMrSIDFile = I18N.get("org.openjump.core.ui.plugin.layer.AddSIDLayerPlugIn.open-MrSID-file");
    static final String sFiles = I18N.get("org.openjump.core.ui.plugin.layer.AddSIDLayerPlugIn.files");
    public static String WORKING_DIR;
    public static String ETC_PATH;
    public static String TMP_PATH;
    public static String MRSIDDECODE;
    public static String MRSIDINFO;

    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuItemWithJava14Fix(this, new String[]{MenuNames.LAYER}, sAddMrSIDLayer + "{pos:3}", false, null, this.createEnableCheck(context.getWorkbenchContext()));
        File empty = new File("");
        String sep = File.separator;
        WORKING_DIR = context.getWorkbenchContext().getWorkbench().getPlugInManager().getPlugInDirectory() + sep;
        ETC_PATH = WORKING_DIR + "etc" + sep;
        TMP_PATH = WORKING_DIR + "etc" + sep + "tmp" + sep;
        MRSIDDECODE = ETC_PATH + "mrsidgeodecode.exe";
        MRSIDINFO = ETC_PATH + "mrsidgeoinfo.exe";
        System.out.println("search for MrSid:" + ETC_PATH);
    }

    public boolean execute(final PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        try {
            context.getWorkbenchFrame().getOutputFrame().createNewDocument();
            if (!new File(MRSIDDECODE).exists()) {
                context.getWorkbenchFrame().warnUser(sErrorSeeOutputWindow);
                context.getWorkbenchFrame().getOutputFrame().addText(MRSIDDECODE + " " + sNotInstalled);
                return false;
            }
            if (!new File(MRSIDINFO).exists()) {
                context.getWorkbenchFrame().warnUser(sErrorSeeOutputWindow);
                context.getWorkbenchFrame().getOutputFrame().addText(MRSIDINFO + " " + sNotInstalled);
                return false;
            }
            JFileChooser fileChooser = new JFileChooser();
            fileChooser = GUIUtil.createJFileChooserWithExistenceChecking();
            fileChooser.setDialogTitle(sOpenMrSIDFile);
            fileChooser.setDialogType(0);
            fileChooser.setFileSelectionMode(0);
            fileChooser.setMultiSelectionEnabled(true);
            GUIUtil.removeChoosableFileFilters(fileChooser);
            FileFilter fileFilter = GUIUtil.createFileFilter("MrSID " + sFiles, new String[]{"sid"});
            fileChooser.addChoosableFileFilter(fileFilter);
            fileChooser.setFileFilter(fileFilter);
            if (0 == fileChooser.showOpenDialog(context.getWorkbenchFrame())) {
                ArrayList<String> imageFilenames = new ArrayList<String>();
                File[] files = fileChooser.getSelectedFiles();
                for (int i = 0; i < files.length; ++i) {
                    String filename = files[i].getCanonicalPath();
                    imageFilenames.add(filename);
                }
                final SIDLayer layer = new SIDLayer(context, imageFilenames);
                this.execute(new UndoableCommand(this.getName()){

                    public void execute() {
                        Collection selectedCategories = context.getLayerNamePanel().getSelectedCategories();
                        context.getLayerManager().addLayerable(selectedCategories.isEmpty() ? StandardCategoryNames.WORKING : selectedCategories.iterator().next().toString(), layer);
                    }

                    public void unexecute() {
                        context.getLayerManager().remove(layer);
                    }
                }, context);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            context.getWorkbenchFrame().warnUser(sErrorSeeOutputWindow);
            context.getWorkbenchFrame().getOutputFrame().addText("AddSIDLayerPlugIn Exception:" + e.toString());
            return false;
        }
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createTaskWindowMustBeActiveCheck());
    }
}

