/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.TitledPopupMenu;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class ChangeLayerableNamePlugIn
extends AbstractPlugIn {
    public void initialize(PlugInContext context) throws Exception {
        WorkbenchContext workbenchContext = context.getWorkbenchContext();
        EnableCheck enableCheck = this.createEnableCheck(workbenchContext);
        FeatureInstaller installer = new FeatureInstaller(workbenchContext);
        installer.addMainMenuItemWithJava14Fix(this, new String[]{MenuNames.LAYER}, this.getName() + "...", false, null, enableCheck);
        TitledPopupMenu popupMenu = workbenchContext.getWorkbench().getFrame().getLayerNamePopupMenu();
        installer.addPopupMenuItem((JPopupMenu)popupMenu, (PlugIn)this, this.getName() + "{pos:5}", false, null, enableCheck);
        popupMenu = workbenchContext.getWorkbench().getFrame().getWMSLayerNamePopupMenu();
        installer.addPopupMenuItem((JPopupMenu)popupMenu, (PlugIn)this, this.getName() + "{pos:6}", false, null, enableCheck);
    }

    public String getName() {
        return I18N.get("org.openjump.core.ui.plugin.layer.ChangeLayerableName.Rename");
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        final Layerable layer = (Layerable)context.getLayerNamePanel().selectedNodes(Layerable.class).iterator().next();
        final String oldName = layer.getName();
        final String newName = (String)JOptionPane.showInputDialog(context.getWorkbenchFrame(), I18N.get("org.openjump.core.ui.plugin.layer.ChangeLayerableName.Rename"), this.getName(), -1, null, null, oldName);
        if (newName != null) {
            this.execute(new UndoableCommand(this.getName()){

                public void execute() {
                    layer.setName(newName);
                }

                public void unexecute() {
                    layer.setName(oldName);
                }
            }, context);
        }
        return true;
    }

    public EnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory enableCheckFactory = new EnableCheckFactory(workbenchContext);
        MultiEnableCheck enableCheck = new MultiEnableCheck();
        enableCheck.add(enableCheckFactory.createWindowWithLayerManagerMustBeActiveCheck());
        enableCheck.add(enableCheckFactory.createExactlyNLayerablesMustBeSelectedCheck(1, Layerable.class));
        return enableCheck;
    }
}

