/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.CopySelectedItemsPlugIn;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorScheme;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingStyle;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class CombineSelectedLayersPlugIn
extends AbstractPlugIn {
    private static final String LAYER = I18N.get("org.openjump.core.ui.plugin.layer.ExtractLayersByAttribute.LAYER");
    private static final String COMBINE_SELECTED_LAYERS = I18N.get("org.openjump.core.ui.plugin.layer.CombineSelectedLayers");

    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuItemWithJava14Fix(this, new String[]{MenuNames.EDIT}, COMBINE_SELECTED_LAYERS, false, null, this.createEnableCheck(context.getWorkbenchContext()));
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        new CopySelectedItemsPlugIn().execute(context);
        Layer[] selectedLayers = context.getLayerNamePanel().getSelectedLayers();
        FeatureSchema featureSchema = new FeatureSchema();
        featureSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        featureSchema.addAttribute(LAYER, AttributeType.STRING);
        for (int i = 0; i < selectedLayers.length; ++i) {
            FeatureSchema schema = selectedLayers[i].getFeatureCollectionWrapper().getFeatureSchema();
            for (int j = 0; j < schema.getAttributeCount(); ++j) {
                String name = schema.getAttributeName(j);
                if (!featureSchema.hasAttribute(name)) {
                    featureSchema.addAttribute(name, schema.getAttributeType(name));
                    continue;
                }
                if (schema.getAttributeType(name) == featureSchema.getAttributeType(name)) continue;
                featureSchema.addAttribute(name + CombineSelectedLayersPlugIn.getAttributeTypeChar(schema.getAttributeType(name)), schema.getAttributeType(name));
            }
        }
        FeatureDataset featureDataset = new FeatureDataset(featureSchema);
        Collection selectedCategories = context.getLayerNamePanel().getSelectedCategories();
        Layer newLayer = context.addLayer(selectedCategories.isEmpty() ? StandardCategoryNames.RESULT : selectedCategories.iterator().next().toString(), "Combined", featureDataset);
        newLayer.setFeatureCollectionModified(true).setEditable(true);
        HashMap<String, BasicStyle> attributeToStyleMap = new HashMap<String, BasicStyle>();
        ColorScheme colorScheme = ColorScheme.create("Set 3 (ColorBrewer)");
        for (int i = 0; i < selectedLayers.length; ++i) {
            Layer layer = selectedLayers[i];
            List features = layer.getFeatureCollectionWrapper().getFeatures();
            newLayer.getFeatureCollectionWrapper().addAll(CombineSelectedLayersPlugIn.conform(features, featureSchema, layer.getName()));
            attributeToStyleMap.put(layer.getName(), new BasicStyle(colorScheme.next()));
        }
        newLayer.getBasicStyle().setEnabled(false);
        ColorThemingStyle themeStyle = new ColorThemingStyle(LAYER, attributeToStyleMap, new BasicStyle(Color.gray));
        themeStyle.setEnabled(true);
        newLayer.addStyle(themeStyle);
        ColorThemingStyle.get(newLayer).setEnabled(true);
        newLayer.removeStyle(ColorThemingStyle.get(newLayer));
        ColorThemingStyle.get(newLayer).setEnabled(true);
        newLayer.getBasicStyle().setEnabled(false);
        return true;
    }

    private static String getAttributeTypeChar(AttributeType type) {
        return type.toString().substring(0, 1);
    }

    public static Collection conform(Collection features, FeatureSchema targetFeatureSchema, String layerName) {
        ArrayList<Feature> featureCopies = new ArrayList<Feature>();
        for (Feature feature : features) {
            featureCopies.add(CombineSelectedLayersPlugIn.conform(feature, targetFeatureSchema, layerName));
        }
        return featureCopies;
    }

    private static Feature conform(Feature original, FeatureSchema targetFeatureSchema, String layerName) {
        BasicFeature copy = new BasicFeature(targetFeatureSchema);
        copy.setGeometry((Geometry)original.getGeometry().clone());
        for (int i = 0; i < original.getSchema().getAttributeCount(); ++i) {
            if (i == original.getSchema().getGeometryIndex()) continue;
            String attributeName = original.getSchema().getAttributeName(i);
            String newAttributeName = original.getSchema().getAttributeName(i);
            if (!copy.getSchema().hasAttribute(attributeName)) continue;
            if (copy.getSchema().getAttributeType(attributeName) != original.getSchema().getAttributeType(attributeName)) {
                newAttributeName = newAttributeName + CombineSelectedLayersPlugIn.getAttributeTypeChar(original.getSchema().getAttributeType(attributeName));
                if (copy.getSchema().getAttributeType(newAttributeName) != original.getSchema().getAttributeType(attributeName)) continue;
            }
            copy.setAttribute(newAttributeName, original.getAttribute(attributeName));
        }
        copy.setAttribute(LAYER, (Object)layerName);
        return copy;
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithSelectionManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustBeSelectedCheck(2));
    }
}

