/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer.pirolraster;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.CollectionOfLayerablesTransferable;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.util.Collection;
import org.openjump.core.ui.plugin.layer.pirolraster.LayerableClipboardPlugIn;

public class PasteRasterImageLayersPlugIn
extends LayerableClipboardPlugIn {
    public String getNameWithMnemonic() {
        return StringUtil.replace(this.getName(), "P", "&P", false);
    }

    public String getName() {
        return I18N.get("org.openjump.core.ui.plugin.layer.pirolraster.PasteRasterImageLayersPlugIn.Paste-Raster-Image-Layers");
    }

    public boolean execute(PlugInContext context) throws Exception {
        Transferable transferable = GUIUtil.getContents(Toolkit.getDefaultToolkit().getSystemClipboard());
        if (!transferable.isDataFlavorSupported(CollectionOfLayerablesTransferable.COLLECTION_OF_LAYERABLES_FLAVOR)) {
            return false;
        }
        Collection layerables = (Collection)transferable.getTransferData(CollectionOfLayerablesTransferable.COLLECTION_OF_LAYERABLES_FLAVOR);
        for (Layerable layerable : layerables) {
            Layerable clone = this.cloneLayerable(layerable);
            clone.setLayerManager(context.getLayerManager());
            context.getLayerManager().addLayerable(StandardCategoryNames.SYSTEM, clone);
            clone.setName(context.getLayerManager().uniqueLayerName(clone.getName()));
        }
        return true;
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck());
    }
}

