/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.queries;

import com.vividsolutions.jump.I18N;

public class Operator {
    private String key;
    public char type;
    public double arg = -1.0;
    public static final Operator BEQ = new Operator("beq", 'B');
    public static final Operator BNE = new Operator("bne", 'B');
    public static final Operator EQ = new Operator("eq", 'N');
    public static final Operator NE = new Operator("ne", 'N');
    public static final Operator LT = new Operator("lt", 'N');
    public static final Operator GT = new Operator("gt", 'N');
    public static final Operator LE = new Operator("le", 'N');
    public static final Operator GE = new Operator("ge", 'N');
    public static final Operator EQUA = new Operator("equa", 'S');
    public static final Operator DIFF = new Operator("diff", 'S');
    public static final Operator STAR = new Operator("star", 'S');
    public static final Operator ENDS = new Operator("ends", 'S');
    public static final Operator MATC = new Operator("matc", 'S');
    public static final Operator FIND = new Operator("find", 'S');
    public static final Operator BEFO = new Operator("befo", 'S');
    public static final Operator AFTE = new Operator("afte", 'S');
    public static final Operator INTER = new Operator("inter", 'G');
    public static final Operator CONTA = new Operator("conta", 'G');
    public static final Operator WITHI = new Operator("withi", 'G');
    public static final Operator WSTRI = new Operator("wstri", 'G');
    public static final Operator WDIST = new Operator("wdist", 'G', 1000.0);
    public static final Operator TOUCH = new Operator("touch", 'G');
    public static final Operator CROSS = new Operator("cross", 'G');
    public static final Operator OVERL = new Operator("overl", 'G');
    public static final Operator DISJO = new Operator("disjo", 'G');
    public static Operator[] BOOLEAN_OP = new Operator[]{BEQ, BNE};
    public static Operator[] NUMERIC_OP = new Operator[]{EQ, NE, LT, GT, LE, GE};
    public static Operator[] STRING_OP = new Operator[]{EQUA, DIFF, STAR, ENDS, MATC, FIND, BEFO, AFTE};
    public static Operator[] GEOMETRIC_OP = new Operator[]{INTER, CONTA, WITHI, WSTRI, WDIST, TOUCH, CROSS, OVERL, DISJO};

    public Operator(String key, char type) {
        this.key = key;
        this.type = type;
    }

    public Operator(String key, char type, double arg) {
        this.key = key;
        this.type = type;
        this.arg = arg;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(I18N.get("org.openjump.core.ui.plugin.queries.Operator." + this.key));
        if (this.arg < 0.0) {
            return sb.toString();
        }
        return sb.toString() + " (" + this.arg + ")";
    }
}

