/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.raster.color;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import java.awt.Color;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import javax.media.jai.PlanarImage;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.ui.color.ColorGenerator;

public class RasterColorEditor {
    private RasterImageLayer layer;
    private ColorGenerator colorGenerator;

    public RasterColorEditor(RasterImageLayer Rlayer) {
        this.setRasterLayer(Rlayer);
    }

    public void setRasterLayer(RasterImageLayer Rlayer) {
        this.layer = Rlayer;
    }

    public RasterImageLayer getRasterImageLayer() {
        return this.layer;
    }

    public void changeColors(WorkbenchContext context, Color[] colors, Color noDataColor, float min, float max) throws NoninvertibleTransformException {
        if (colors == null || colors.length == 0) {
            this.layer.setNeedToKeepImage(false);
            this.layer.flushImages(true);
            this.layer.setEnvelope(this.layer.getEnvelope());
            context.getLayerViewPanel().getViewport().update();
            return;
        }
        this.colorGenerator = new ColorGenerator(35, colors);
        Raster raster = this.layer.getRasterData();
        int width = raster.getWidth();
        int height = raster.getHeight();
        BufferedImage newImage = new BufferedImage(width, height, 6);
        int numOfSteps = this.colorGenerator.getSteps();
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                float value = raster.getSampleFloat(j, i, 0);
                if ((double)value == Double.POSITIVE_INFINITY) {
                    newImage.setRGB(j, i, 3);
                    continue;
                }
                int intColor = (int)((value - min) / (max - min) * (float)(numOfSteps - 1));
                if (intColor >= numOfSteps || intColor < 0) {
                    newImage.setRGB(j, i, Color.BLACK.getRGB());
                    continue;
                }
                Color newColor = this.colorGenerator.getColor(intColor);
                if (newColor == null) {
                    // empty if block
                }
                newImage.setRGB(j, i, newColor.getRGB());
            }
        }
        PlanarImage pimage = PlanarImage.wrapRenderedImage((RenderedImage)newImage);
        this.layer.setNeedToKeepImage(true);
        this.layer.setImage(pimage);
        this.layer.setEnvelope(this.layer.getEnvelope());
        context.getLayerViewPanel().getViewport().update();
    }
}

