/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.tools.AttributeMapping;
import com.vividsolutions.jump.tools.OverlayEngine;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import org.openjump.core.graph.delauneySimplexInsert.DTriangulationForJTS;

public class CreateThiessenPolygonsPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private String sName = "Create Thiessen Polygons";
    private String CLAYER = "select point layer";
    private String BLAYER = "background layer to delineate the thiessen polygon size";
    private String sUseBGD = "use background layer";
    private String sideBarText = "Creates a Delaunay triangulation and returns the Voronoi regions.";
    private String msgCreateDG = "create triangulation";
    private String msgCreatePolys = "create polygons from voronoi edges";
    private String msgAddAttributesPolys = "add attributes from points";
    private String msgMultiplePointsInPoly = "Error: found multiple points in polygon";
    private String msgNoPoint = "no point geometry";
    private Layer itemlayer = null;
    private Layer bckgrdlayer = null;
    private PlugInContext pcontext = null;
    private boolean useBackground = false;
    private MultiInputDialog dialog;
    private JCheckBox checkbox;
    private JComboBox layerComboBoxBackground;

    public void initialize(PlugInContext context) throws Exception {
        this.CLAYER = I18N.get("org.openjump.core.ui.plugin.tools.CreateThiessenPolygonsPlugIn.select-point-layer");
        this.BLAYER = I18N.get("org.openjump.core.ui.plugin.tools.CreateThiessenPolygonsPlugIn.background-layer-to-estimate-the-thiessen-polygon-size");
        this.sUseBGD = I18N.get("org.openjump.core.ui.plugin.tools.CreateThiessenPolygonsPlugIn.use-background-layer");
        this.sName = I18N.get("org.openjump.core.ui.plugin.tools.CreateThiessenPolygonsPlugIn.Create-Thiessen-Polygons");
        this.sideBarText = I18N.get("org.openjump.core.ui.plugin.tools.CreateThiessenPolygonsPlugIn.Creates-a-Delaunay-triangulation-and-returns-the-Voronoi-regions");
        this.msgCreateDG = I18N.get("org.openjump.core.ui.plugin.tools.CreateThiessenPolygonsPlugIn.create-triangulation");
        this.msgCreatePolys = I18N.get("org.openjump.core.ui.plugin.tools.CreateThiessenPolygonsPlugIn.create-polygons-from-voronoi-edges");
        this.msgNoPoint = I18N.get("org.openjump.core.ui.plugin.tools.CreateThiessenPolygonsPlugIn.no-point-geometry");
        this.msgAddAttributesPolys = I18N.get("org.openjump.core.ui.plugin.tools.CreateThiessenPolygonsPlugIn.add-attributes-from-points");
        this.msgMultiplePointsInPoly = I18N.get("org.openjump.core.ui.plugin.tools.CreateThiessenPolygonsPlugIn.Error-found-multiple-points-in-polygon");
        this.pcontext = context;
        FeatureInstaller featureInstaller = new FeatureInstaller(context.getWorkbenchContext());
        featureInstaller.addMainMenuItem(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_GENERATE}, this.sName + "...", false, null, CreateThiessenPolygonsPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.sName, true);
        this.setDialogValues(this.dialog, context);
        GUIUtil.centreOnWindow(this.dialog);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        return true;
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(this.sideBarText);
        JComboBox addLayerComboBoxBuild = dialog.addLayerComboBox(this.CLAYER, context.getCandidateLayer(0), null, context.getLayerManager());
        this.checkbox = dialog.addCheckBox(this.sUseBGD, this.useBackground);
        this.checkbox.addItemListener(new MethodItemListener());
        this.layerComboBoxBackground = dialog.addLayerComboBox(this.BLAYER, context.getCandidateLayer(0), null, context.getLayerManager());
        this.layerComboBoxBackground.setEnabled(this.useBackground);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.itemlayer = dialog.getLayer(this.CLAYER);
        this.bckgrdlayer = dialog.getLayer(this.BLAYER);
        this.useBackground = dialog.getBoolean(this.sUseBGD);
    }

    private void updateUIForMethod() {
        boolean val = this.checkbox.isSelected();
        this.layerComboBoxBackground.setEnabled(val);
        this.dialog.validate();
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        this.createGraph(context, monitor);
        System.gc();
    }

    private boolean createGraph(PlugInContext context, TaskMonitor monitor) throws Exception {
        System.gc();
        List features = this.itemlayer.getFeatureCollectionWrapper().getFeatures();
        List bkg = this.bckgrdlayer.getFeatureCollectionWrapper().getFeatures();
        ArrayList<Geometry> points = new ArrayList<Geometry>();
        Quadtree qtree = new Quadtree();
        for (Feature f : features) {
            Geometry g = f.getGeometry();
            if (g instanceof Point) {
                if (this.useBackground) {
                    boolean isInside = false;
                    for (Feature ftemp : bkg) {
                        if (!ftemp.getGeometry().covers(g)) continue;
                        isInside = true;
                    }
                    if (!isInside) continue;
                    points.add(f.getGeometry());
                    qtree.insert(g.getEnvelopeInternal(), (Object)f);
                    continue;
                }
                points.add(f.getGeometry());
                qtree.insert(g.getEnvelopeInternal(), (Object)f);
                continue;
            }
            context.getWorkbenchFrame().warnUser(this.msgNoPoint);
        }
        if (points.size() > 0) {
            monitor.report(this.msgCreateDG);
            DTriangulationForJTS tri = null;
            if (this.useBackground) {
                FeatureCollectionWrapper fc = this.bckgrdlayer.getFeatureCollectionWrapper();
                Envelope env = fc.getEnvelope();
                tri = new DTriangulationForJTS(points, env);
            } else {
                tri = new DTriangulationForJTS(points);
            }
            monitor.report(this.msgCreatePolys);
            ArrayList polys = tri.getThiessenPolys();
            monitor.report(this.msgAddAttributesPolys);
            FeatureCollection myCollC = this.transferAttributes(this.itemlayer.getFeatureCollectionWrapper().getFeatureSchema(), qtree, polys);
            if (this.useBackground) {
                OverlayEngine oe = new OverlayEngine();
                FeatureDataset a = myCollC;
                FeatureCollectionWrapper b = this.bckgrdlayer.getFeatureCollectionWrapper();
                AttributeMapping mapping = new AttributeMapping(a.getFeatureSchema(), new FeatureSchema());
                FeatureCollection overlay = oe.overlay(a, b, mapping, monitor);
                myCollC = overlay;
            }
            context.addLayer(StandardCategoryNames.WORKING, "Thiessen polygons", myCollC);
        } else {
            context.getWorkbenchFrame().warnUser(this.msgNoPoint);
        }
        return true;
    }

    public FeatureDataset transferAttributes(FeatureSchema fs, Quadtree treeWithFeatures, ArrayList thiessenGeoms) {
        FeatureDataset fd = new FeatureDataset(fs);
        for (Geometry poly : thiessenGeoms) {
            Feature newFeature = new BasicFeature(fs);
            newFeature.setGeometry(poly);
            List candidates = treeWithFeatures.query(poly.getEnvelopeInternal());
            int pointsInside = 0;
            for (Feature pt : candidates) {
                if (!poly.contains(pt.getGeometry())) continue;
                newFeature = pt.clone(false);
                newFeature.setGeometry(poly);
                if (++pointsInside <= 1) continue;
                this.pcontext.getWorkbenchFrame().warnUser(this.msgMultiplePointsInPoly + ": " + pointsInside);
                if (pointsInside != 2) continue;
                newFeature = new BasicFeature(fs);
                newFeature.setGeometry(poly);
            }
            fd.add(newFeature);
        }
        return fd;
    }

    private class MethodItemListener
    implements ItemListener {
        private MethodItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            CreateThiessenPolygonsPlugIn.this.updateUIForMethod();
        }
    }
}

