/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.IndexedFeatureCollection;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.tools.AttributeMapping;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SpatialJoinPlugIn
extends ThreadedBasePlugIn {
    private static final String LAYER1 = GenericNames.LAYER_A;
    private static final String LAYER2 = GenericNames.LAYER_B;
    private static String METHODS = I18N.get("org.openjump.sigle.plugin.SpatialJoinPlugIn.spatial-operation");
    private static String METHOD_EQUAL = I18N.get("org.openjump.sigle.plugin.SpatialJoinPlugIn.equal");
    private static String METHOD_WITHIN = "A " + I18N.get("org.openjump.sigle.plugin.SpatialJoinPlugIn.within") + " B";
    private static String METHOD_EQUAL_AND_WITHIN = "A " + I18N.get("org.openjump.sigle.plugin.SpatialJoinPlugIn.equal-AND-within B");
    private static String METHOD_EQUAL_OR_WITHIN = "A " + I18N.get("org.openjump.sigle.plugin.SpatialJoinPlugIn.equal-OR-within B");
    private Collection SpatialJoinMethodNames = SpatialJoinPlugIn.getSpatialJoinMethodNames();
    private MultiInputDialog dialog;
    private Layer layer1;
    private Layer layer2;
    private String methodNameToRun;
    private boolean exceptionThrown = false;

    private static Collection getSpatialJoinMethodNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(METHOD_EQUAL);
        names.add(METHOD_WITHIN);
        names.add(METHOD_EQUAL_AND_WITHIN);
        names.add(METHOD_EQUAL_OR_WITHIN);
        return names;
    }

    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuItem(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_ATTRIBUTES}, this.getName(), false, null, new MultiEnableCheck().add(new EnableCheckFactory(context.getWorkbenchContext()).createTaskWindowMustBeActiveCheck()).add(new EnableCheckFactory(context.getWorkbenchContext()).createAtLeastNLayersMustExistCheck(2)));
    }

    public boolean execute(PlugInContext context) throws Exception {
        METHODS = I18N.get("org.openjump.sigle.plugin.SpatialJoinPlugIn.spatial-operation");
        METHOD_EQUAL = I18N.get("org.openjump.sigle.plugin.SpatialJoinPlugIn.equal");
        METHOD_WITHIN = "A " + I18N.get("org.openjump.sigle.plugin.SpatialJoinPlugIn.within B");
        METHOD_EQUAL_AND_WITHIN = "A " + I18N.get("org.openjump.sigle.plugin.SpatialJoinPlugIn.equal-AND-within B");
        METHOD_EQUAL_OR_WITHIN = "A " + I18N.get("org.openjump.sigle.plugin.SpatialJoinPlugIn.equal-OR-within B");
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    public String getName() {
        return I18N.get("org.openjump.sigle.plugin.SpatialJoinPlugIn.Transfer-Attributes");
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        FeatureSchema featureSchema = new FeatureSchema();
        FeatureCollection resultColl = this.runSpatialJoinMethod(this.layer1.getFeatureCollectionWrapper(), this.layer2.getFeatureCollectionWrapper(), this.methodNameToRun);
        if (resultColl.size() > 0) {
            context.addLayer(StandardCategoryNames.WORKING, I18N.get("org.openjump.sigle.plugin.SpatialJoinPlugIn.Result") + this.methodNameToRun, resultColl);
        }
        if (this.exceptionThrown) {
            context.getWorkbenchFrame().warnUser(I18N.get("org.openjump.sigle.plugin.SpatialJoinPlugIn.Error-while-executing-spatial-function"));
        }
    }

    private FeatureCollection runSpatialJoinMethod(FeatureCollection fcA, FeatureCollection fcB, String methodName) {
        this.exceptionThrown = false;
        Feature fEqual = null;
        Feature fWithin = null;
        Feature fEqualAndWithin = null;
        Feature fEqualOrWithin = null;
        AttributeMapping mapping = null;
        mapping = new AttributeMapping(new FeatureSchema(), new FeatureSchema());
        List aFeatures = null;
        mapping = new AttributeMapping(fcB.getFeatureSchema(), fcA.getFeatureSchema());
        aFeatures = fcA.getFeatures();
        FeatureDataset fcRecup = new FeatureDataset(mapping.createSchema("GEOMETRY"));
        IndexedFeatureCollection indexedB = new IndexedFeatureCollection(fcB);
        for (int i = 0; i < aFeatures.size(); ++i) {
            Feature aFeature = (Feature)aFeatures.get(i);
            BasicFeature feature = new BasicFeature(fcRecup.getFeatureSchema());
            int nbFeatureEqual = 0;
            int nbFeatureWithin = 0;
            int nbFeatureEqualAndWithin = 0;
            int nbFeatureEqualOrWithin = 0;
            int nbFeature = 0;
            for (Feature bFeature : indexedB.query(aFeature.getGeometry().getEnvelopeInternal())) {
                if (methodName.equals(METHOD_EQUAL)) {
                    if (!aFeature.getGeometry().equals(bFeature.getGeometry())) continue;
                    ++nbFeatureEqual;
                    ++nbFeature;
                    fEqual = bFeature;
                    continue;
                }
                if (methodName.equals(METHOD_WITHIN)) {
                    if (!aFeature.getGeometry().within(bFeature.getGeometry())) continue;
                    ++nbFeatureWithin;
                    ++nbFeature;
                    fWithin = bFeature;
                    continue;
                }
                if (methodName.equals(METHOD_EQUAL_AND_WITHIN)) {
                    if (!aFeature.getGeometry().equals(bFeature.getGeometry()) || !aFeature.getGeometry().within(bFeature.getGeometry())) continue;
                    ++nbFeatureEqualAndWithin;
                    ++nbFeature;
                    fEqualAndWithin = bFeature;
                    continue;
                }
                if (!methodName.equals(METHOD_EQUAL_OR_WITHIN) || !aFeature.getGeometry().equals(bFeature.getGeometry()) && !aFeature.getGeometry().within(bFeature.getGeometry())) continue;
                ++nbFeatureEqualOrWithin;
                ++nbFeature;
                fEqualOrWithin = bFeature;
            }
            if (nbFeatureEqual == 1) {
                mapping.transferAttributes(fEqual, aFeature, feature);
                feature.setGeometry((Geometry)aFeature.getGeometry().clone());
                fcRecup.add(feature);
                continue;
            }
            if (nbFeatureWithin == 1) {
                mapping.transferAttributes(fWithin, aFeature, feature);
                feature.setGeometry((Geometry)aFeature.getGeometry().clone());
                fcRecup.add(feature);
                continue;
            }
            if (nbFeatureEqualAndWithin == 1) {
                mapping.transferAttributes(fEqualAndWithin, aFeature, feature);
                feature.setGeometry((Geometry)aFeature.getGeometry().clone());
                fcRecup.add(feature);
                continue;
            }
            if (nbFeatureEqualOrWithin != true) continue;
            mapping.transferAttributes(fEqualOrWithin, aFeature, feature);
            feature.setGeometry((Geometry)aFeature.getGeometry().clone());
            fcRecup.add(feature);
        }
        return fcRecup;
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(I18N.get("org.openjump.sigle.plugin.SpatialJoinPlugIn.Transfers-the-attributes-of-Layer-B-to-Layer-A-using-a-spatial-criterion"));
        dialog.addLayerComboBox(LAYER1, this.layer1, context.getLayerManager());
        dialog.addLayerComboBox(LAYER2, this.layer2, context.getLayerManager());
        dialog.addComboBox(METHODS, this.methodNameToRun, this.SpatialJoinMethodNames, null);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.layer1 = dialog.getLayer(LAYER1);
        this.layer2 = dialog.getLayer(LAYER2);
        this.methodNameToRun = dialog.getText(METHODS);
    }
}

