/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingManager;
import com.vividsolutions.jump.workbench.ui.zoom.AbstractZoomTool;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class ZoomRealtimeTool
extends AbstractZoomTool {
    private static final double ZOOM_FACTOR = 5.0;
    private static final double ZOOM_OUT_LIMIT = 0.1;
    private boolean dragging = false;
    private boolean rightMouse = false;
    private static final String sName = I18N.get("org.openjump.core.ui.plugin.tools.ZoomRealtimeTool.Zoom-Realtime");

    public Cursor getCursor() {
        return ZoomRealtimeTool.createCursor(IconLoader.icon("MagnifyCursor2.gif").getImage());
    }

    public Icon getIcon() {
        return IconLoader.icon("Magnify3.gif");
    }

    public boolean isRightMouseButtonUsed() {
        return true;
    }

    public String getName() {
        return sName;
    }

    public void mouseDragged(MouseEvent e) {
        try {
            this.rightMouse = SwingUtilities.isRightMouseButton(e);
            if (!this.dragging) {
                this.dragging = true;
                this.getPanel().getRenderingManager().setPaintingEnabled(false);
                this.cacheImage();
            }
            this.drawImage(e.getPoint());
            super.mouseDragged(e);
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (!this.dragging) {
            try {
                this.getPanel().getViewport().zoomToViewPoint(e.getPoint(), 1.0);
            }
            catch (NoninvertibleTransformException ex) {
                return;
            }
        }
        this.getPanel().getRenderingManager().setPaintingEnabled(true);
        this.dragging = false;
        super.mouseReleased(e);
    }

    protected Shape getShape(Point2D source, Point2D destination) {
        return null;
    }

    protected void gestureFinished() throws NoninvertibleTransformException {
        this.reportNothingToUndoYet();
        RenderingManager renderManager = this.getPanel().getRenderingManager();
        renderManager.setPaintingEnabled(false);
        this.getPanel().getViewport().zoomToViewPoint(this.zoomTo, this.scale);
        renderManager.getDefaultRendererThreadQueue().add(new Runnable(){

            public void run() {
                RenderingManager renderManager = ZoomRealtimeTool.this.getPanel().getRenderingManager();
                renderManager.setPaintingEnabled(true);
                renderManager.repaintPanel();
            }
        });
    }

    private void drawImage(Point p) throws NoninvertibleTransformException {
        double xdrag = p.getX() - this.getViewSource().getX();
        double ydrag = p.getY() - this.getViewSource().getY();
        double scaleFactor = this.rightMouse ? 5.0 * xdrag : 5.0 * ydrag;
        double w = this.origImage.getWidth(this.getPanel());
        double h = this.origImage.getHeight(this.getPanel());
        this.scale = (h + scaleFactor) / h;
        this.scale = this.scale < 0.1 ? 0.1 : this.scale;
        double w2 = w * this.scale;
        double h2 = h * this.scale;
        double dx = (w - w2) / 2.0;
        double dy = (h - h2) / 2.0;
        double xoff = 0.0;
        double yoff = 0.0;
        if (this.rightMouse) {
            yoff = ydrag / this.scale;
        } else {
            xoff = xdrag / this.scale;
        }
        this.zoomTo.x = dx + w2 / 2.0 - xoff;
        this.zoomTo.y = dy + h2 / 2.0 - yoff;
        if (this.rightMouse) {
            dy += ydrag;
        } else {
            dx += xdrag;
        }
        this.drawImage((int)dx, (int)dy, this.scale);
    }
}

