/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools.geometrychange;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import org.openjump.core.apitools.FeatureCollectionTools;

public class ExtractPointsPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private String sName = "Extract Points";
    private String CLAYER = "select layer";
    private String DELETE_LAST_POINT_IF_CLOSED = "Account for closed Geometries";
    private String sideBarText = "Extracts points from polygon or line features and writes them to a new layer. Note, for closed geometries start point and end point are the same. If closed geometries are to be observed,then the last point is not returned to avoid two overlaying points.";
    private String sPoints = "points";
    private Layer itemlayer = null;
    private boolean deleteDoublePoints = false;
    private MultiInputDialog dialog;
    private JComboBox layerComboBoxBackground;

    public void initialize(PlugInContext context) throws Exception {
        this.CLAYER = GenericNames.LAYER;
        this.sName = I18N.get("org.openjump.core.ui.plugin.tools.ExtractPointsPlugIn.Extract-Points");
        this.sideBarText = I18N.get("org.openjump.core.ui.plugin.tools.ExtractPointsPlugIn.description");
        this.sPoints = I18N.get("org.openjump.core.ui.plugin.tools.ExtractPointsPlugIn.points");
        this.DELETE_LAST_POINT_IF_CLOSED = I18N.get("org.openjump.core.ui.plugin.tools.ExtractPointsPlugIn.Account-for-closed-Geometries");
        FeatureInstaller featureInstaller = new FeatureInstaller(context.getWorkbenchContext());
        featureInstaller.addMainMenuItem(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_GEOMETRY, MenuNames.CONVERT}, this.sName + "...", false, null, ExtractPointsPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.sName, true);
        this.setDialogValues(this.dialog, context);
        GUIUtil.centreOnWindow(this.dialog);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        return true;
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(this.sideBarText);
        JComboBox addLayerComboBoxBuild = dialog.addLayerComboBox(this.CLAYER, context.getCandidateLayer(0), null, context.getLayerManager());
        dialog.addCheckBox(this.DELETE_LAST_POINT_IF_CLOSED, this.deleteDoublePoints);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.itemlayer = dialog.getLayer(this.CLAYER);
        this.deleteDoublePoints = dialog.getBoolean(this.DELETE_LAST_POINT_IF_CLOSED);
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        System.gc();
        List features = this.itemlayer.getFeatureCollectionWrapper().getFeatures();
        FeatureSchema fs = this.itemlayer.getFeatureCollectionWrapper().getFeatureSchema();
        String ITEM_ID = "item_id";
        String SEQ_ID = "sequence_id";
        FeatureSchema fsNew = (FeatureSchema)fs.clone();
        fsNew.addAttribute("item_id", AttributeType.INTEGER);
        fsNew.addAttribute("sequence_id", AttributeType.INTEGER);
        FeatureDataset fd = new FeatureDataset(fsNew);
        int count = 0;
        for (Feature f : features) {
            ArrayList<Feature> points = FeatureCollectionTools.convertToPointFeature(f, this.deleteDoublePoints);
            int seq_count = 0;
            for (Feature pt : points) {
                pt = FeatureCollectionTools.copyFeatureAndSetFeatureSchema(pt, fsNew);
                pt.setAttribute("item_id", (Object)count);
                pt.setAttribute("sequence_id", (Object)seq_count);
                fd.add(pt);
                ++seq_count;
            }
            ++count;
        }
        context.addLayer(StandardCategoryNames.RESULT, this.itemlayer.getName() + "-" + this.sPoints, fd);
    }
}

