/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools.statistics;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import org.openjump.core.apitools.FeatureSchemaTools;
import org.openjump.core.ui.plot.Plot2DPanelOJ;

public class CreateScatterPlotPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private static String pluginname = "classifyplot";
    private String sScatterPlot = "Scatter-Plot";
    private MultiInputDialog dialog;
    private String CLAYER = "select layer";
    private String ATTRIBUTEA = "Select-attribute-for-east-axis";
    private String ATTRIBUTEB = "Select-attribute-for-north-axis";
    private Layer selLayer = null;
    private FeatureCollection fc = null;
    private String selAttributeA = null;
    private String selAttributeB = null;
    private String sName = "Create Scatter Plot";
    private String sWrongDataType = "Wrong datatype of chosen attribute";

    public void initialize(PlugInContext context) throws Exception {
        this.ATTRIBUTEA = I18N.get("org.openjump.core.ui.plugin.tools.statistics.CreateScatterPlotPlugIn.Select-attribute-for-east-axis");
        this.ATTRIBUTEB = I18N.get("org.openjump.core.ui.plugin.tools.statistics.CreateScatterPlotPlugIn.Select-attribute-for-north-axis");
        this.CLAYER = GenericNames.SELECT_LAYER;
        this.sScatterPlot = I18N.get("org.openjump.core.ui.plugin.tools.statistics.CreateScatterPlotPlugIn.Scatter-Plot");
        this.sName = I18N.get("org.openjump.core.ui.plugin.tools.statistics.CreateScatterPlotPlugIn.Create-Scatter-Plot");
        this.sWrongDataType = I18N.get("org.openjump.core.ui.plugin.tools.statistics.CreateBarPlotPlugIn.Wrong-datatype-of-chosen-attribute");
        FeatureInstaller featureInstaller = new FeatureInstaller(context.getWorkbenchContext());
        featureInstaller.addMainMenuItem(this, new String[]{MenuNames.TOOLS, MenuNames.STATISTICS, MenuNames.PLOT}, this.sName + "...", false, null, CreateScatterPlotPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayersMustExistCheck(1)).add(checkFactory.createTaskWindowMustBeActiveCheck());
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.sName, true);
        this.setDialogValues(this.dialog, context);
        GUIUtil.centreOnWindow(this.dialog);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        return true;
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        this.createPlot(context, this.selLayer);
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.addLayerComboBox(this.CLAYER, context.getCandidateLayer(0), context.getLayerManager());
        List list = FeatureSchemaTools.getFieldsFromLayerWithoutGeometryAndString(context.getCandidateLayer(0));
        Object valA = list.size() > 0 ? list.iterator().next() : null;
        Object valB = list.size() > 0 ? list.iterator().next() : null;
        final JComboBox jcb_attributeA = dialog.addComboBox(this.ATTRIBUTEA, valA, list, this.ATTRIBUTEA);
        if (list.size() == 0) {
            jcb_attributeA.setEnabled(false);
        }
        final JComboBox jcb_attributeB = dialog.addComboBox(this.ATTRIBUTEB, valB, list, this.ATTRIBUTEB);
        if (list.size() == 0) {
            jcb_attributeB.setEnabled(false);
        }
        dialog.getComboBox(this.CLAYER).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                List list = CreateScatterPlotPlugIn.this.getFieldsFromLayerWithoutGeometryAndString();
                if (list.size() == 0) {
                    jcb_attributeA.setModel(new DefaultComboBoxModel<String>(new String[0]));
                    jcb_attributeA.setEnabled(false);
                }
                jcb_attributeA.setModel(new DefaultComboBoxModel<String>(list.toArray(new String[0])));
            }
        });
        dialog.getComboBox(this.CLAYER).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                List list = CreateScatterPlotPlugIn.this.getFieldsFromLayerWithoutGeometryAndString();
                if (list.size() == 0) {
                    jcb_attributeB.setModel(new DefaultComboBoxModel<String>(new String[0]));
                    jcb_attributeB.setEnabled(false);
                }
                jcb_attributeB.setModel(new DefaultComboBoxModel<String>(list.toArray(new String[0])));
            }
        });
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.selLayer = dialog.getLayer(this.CLAYER);
        this.fc = this.selLayer.getFeatureCollectionWrapper();
        this.selAttributeA = dialog.getText(this.ATTRIBUTEA);
        this.selAttributeB = dialog.getText(this.ATTRIBUTEB);
    }

    private boolean createPlot(PlugInContext context, Layer selLayer) throws Exception {
        FeatureSchema fs = this.fc.getFeatureSchema();
        AttributeType typeA = null;
        AttributeType typeB = null;
        if (fs.getAttributeType(this.selAttributeA) != AttributeType.DOUBLE && fs.getAttributeType(this.selAttributeA) != AttributeType.INTEGER || fs.getAttributeType(this.selAttributeB) != AttributeType.DOUBLE && fs.getAttributeType(this.selAttributeB) != AttributeType.INTEGER) {
            context.getWorkbenchFrame().warnUser(this.sWrongDataType);
            return false;
        }
        typeA = fs.getAttributeType(this.selAttributeA);
        typeB = fs.getAttributeType(this.selAttributeB);
        double[][] data = new double[2][this.fc.size()];
        int[] fID = new int[this.fc.size()];
        int i = 0;
        Iterator iter = this.fc.iterator();
        while (iter.hasNext()) {
            Feature f = (Feature)iter.next();
            fID[i] = f.getID();
            Object valA = f.getAttribute(this.selAttributeA);
            Object valB = f.getAttribute(this.selAttributeB);
            if (typeA == AttributeType.DOUBLE) {
                data[0][i] = (Double)valA;
            } else if (typeA == AttributeType.INTEGER) {
                data[0][i] = ((Integer)valA).intValue();
            }
            if (typeB == AttributeType.DOUBLE) {
                data[1][i] = (Double)valB;
            } else if (typeB == AttributeType.INTEGER) {
                data[1][i] = ((Integer)valB).intValue();
            }
            ++i;
        }
        Plot2DPanelOJ plot = new Plot2DPanelOJ();
        plot.addScatterPlotOJ(this.sScatterPlot, data, fID, context, selLayer);
        plot.plotToolBar.setVisible(true);
        plot.setAxisLabel(0, this.selAttributeA);
        plot.setAxisLabel(1, this.selAttributeB);
        JInternalFrame frame = new JInternalFrame(this.sScatterPlot);
        frame.setLayout(new BorderLayout());
        frame.add((Component)((Object)plot), "Center");
        frame.setClosable(true);
        frame.setResizable(true);
        frame.setMaximizable(true);
        frame.setSize(450, 450);
        frame.setVisible(true);
        context.getWorkbenchFrame().addInternalFrame(frame);
        return true;
    }

    private List getFieldsFromLayerWithoutGeometryAndString() {
        return FeatureSchemaTools.getFieldsFromLayerWithoutGeometryAndString(this.dialog.getLayer(this.CLAYER));
    }
}

