/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.view;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.toolbox.ToolboxDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class EasyPanel
extends JPanel {
    public static final String EZ_LIST_KEY = EasyPanel.class.getName() + "EZ_LIST_KEY";
    private String UNUSED_BUTTON_NAME = I18N.get("org.openjump.core.ui.plugin.view.EasyPanel.Right-Click-to-Assign-Button-F");
    private String RIGHT_CLICK_MENU = I18N.get("org.openjump.core.ui.plugin.view.EasyPanel.Map-Right-Click");
    private JPanel buttonPanel = new JPanel();
    private GridLayout gridLayout1 = new GridLayout();
    private final int MAX_BUTTONS = 10;
    private CustomButton[] buttons = new CustomButton[10];
    private CustomButton activeButton = null;
    private JPopupMenu masterPopup = new JPopupMenu();
    private JMenu rightClickMenu = new JMenu(this.RIGHT_CLICK_MENU);
    private ArrayList<JMenuItem> menuItemList = new ArrayList();
    private ArrayList<String> menuNameList = new ArrayList();
    private ToolboxDialog toolbox;

    public EasyPanel(ToolboxDialog toolbox) {
        this.toolbox = toolbox;
        this.add(this.buttonPanel);
        this.buttonPanel.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(10);
        this.addButtons();
        this.populatePopupMenu(toolbox.getContext());
        this.recallButtonAssignments();
        toolbox.pack();
    }

    private void addButtons() {
        GridBagConstraints gbc = new GridBagConstraints();
        for (int i = 0; i < 10; ++i) {
            this.buttons[i] = new CustomButton(i);
            this.buttonPanel.add((Component)this.buttons[i], gbc);
            PopupListener popupListener = new PopupListener(this.masterPopup);
            this.buttons[i].addMouseListener(popupListener);
            this.buttons[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EasyPanel.this.buttonActionPerformed(e);
                }
            });
        }
    }

    private void recallButtonAssignments() {
        ArrayList buttonNameList = this.getPersistentButtonList(this.toolbox.getContext());
        int buttonNumber = 0;
        int n = 0;
        for (String name : buttonNameList) {
            int index = this.menuNameList.indexOf(name);
            if (index > -1) {
                JMenuItem jMenuItemToSet = this.menuItemList.get(index);
                this.buttons[buttonNumber].setMenuItem(jMenuItemToSet);
                String buttonName = this.buttons[buttonNumber].getText();
                this.buttons[buttonNumber].setText(buttonName + "  F" + ++n);
            } else {
                this.buttons[buttonNumber].setText(this.UNUSED_BUTTON_NAME + ++n);
            }
            ++buttonNumber;
        }
    }

    private void buttonActionPerformed(ActionEvent e) {
        String name = e.getActionCommand();
        CustomButton button = null;
        for (int i = 0; i < this.buttons.length; ++i) {
            if (!this.buttons[i].getText().equalsIgnoreCase(name)) continue;
            button = this.buttons[i];
            break;
        }
        if (button != null) {
            button.executeMenuItem();
        }
    }

    private void populatePopupMenu(WorkbenchContext context) {
        JMenuBar jMenuBar = context.getWorkbench().getFrame().getJMenuBar();
        int menuCount = jMenuBar.getMenuCount();
        for (int i = 0; i < menuCount; ++i) {
            JMenu jMenuRef = jMenuBar.getMenu(i);
            this.masterPopup.add(this.populateMenu(jMenuRef));
        }
        JPopupMenu jPopupMenu = LayerViewPanel.popupMenu();
        int itemCount = jPopupMenu.getComponentCount();
        for (int j = 0; j < itemCount; ++j) {
            if (jPopupMenu.getComponent(j) instanceof JMenuItem) {
                JMenuItem jMenuItemRef = (JMenuItem)jPopupMenu.getComponent(j);
                CustomJMenuItem jMenuItem = new CustomJMenuItem(jMenuItemRef);
                this.rightClickMenu.add(jMenuItem);
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        EasyPanel.this.menuItemActionPerformed(e);
                    }
                });
                continue;
            }
            this.rightClickMenu.insertSeparator(j);
        }
        this.masterPopup.add(this.rightClickMenu);
    }

    private JMenuItem populateMenu(JMenu jMenuRef) {
        JMenu jMenu = new JMenu(jMenuRef.getText());
        int itemCount = jMenuRef.getItemCount();
        for (int j = 0; j < itemCount; ++j) {
            JMenuItem jMenuItemRef = jMenuRef.getItem(j);
            if (jMenuItemRef instanceof JMenu) {
                jMenu.add(this.populateMenu((JMenu)jMenuItemRef));
                continue;
            }
            if (jMenuItemRef instanceof JMenuItem) {
                CustomJMenuItem jMenuItem = new CustomJMenuItem(jMenuItemRef);
                this.menuNameList.add(jMenuItem.getText());
                this.menuItemList.add(jMenuItemRef);
                jMenu.add(jMenuItem);
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        EasyPanel.this.menuItemActionPerformed(e);
                    }
                });
                continue;
            }
            jMenu.insertSeparator(j);
        }
        return jMenu;
    }

    private void menuItemActionPerformed(ActionEvent e) {
        Object source = e.getSource();
        String name = e.getActionCommand();
        if (this.activeButton != null && source instanceof CustomJMenuItem) {
            CustomJMenuItem jMenuItem = (CustomJMenuItem)source;
            JMenuItem referencedJMenuItem = jMenuItem.getReferencedJMenuItem();
            this.activeButton.setMenuItem(referencedJMenuItem);
        }
        this.toolbox.pack();
    }

    private ArrayList getPersistentButtonList(WorkbenchContext context) {
        ArrayList list;
        Blackboard blackboard = PersistentBlackboardPlugIn.get(context);
        if (blackboard.get(EZ_LIST_KEY) == null) {
            list = new ArrayList(10);
            for (int i = 0; i < 10; ++i) {
                list.add(new String(this.UNUSED_BUTTON_NAME + (i + 1)));
            }
            blackboard.put(EZ_LIST_KEY, list);
        }
        list = (ArrayList)blackboard.get(EZ_LIST_KEY);
        return list;
    }

    private void setPersistentButtonList(WorkbenchContext context, int index, String buttonName) {
        ArrayList buttonNameList = this.getPersistentButtonList(context);
        if (index < 10) {
            buttonNameList.set(index, buttonName);
        }
        Blackboard blackboard = PersistentBlackboardPlugIn.get(context);
        blackboard.put(EZ_LIST_KEY, buttonNameList);
    }

    class CustomJMenuItem
    extends JMenuItem {
        private JMenuItem referencedJMenuItem;

        public CustomJMenuItem(JMenuItem jMenuItem) {
            super(jMenuItem.getText());
            this.referencedJMenuItem = null;
            this.referencedJMenuItem = jMenuItem;
        }

        public JMenuItem getReferencedJMenuItem() {
            return this.referencedJMenuItem;
        }
    }

    class CustomButton
    extends JButton {
        private JMenuItem jMenuItem;
        private int buttonNumber;

        public CustomButton(int buttonNumber) {
            super(EasyPanel.this.UNUSED_BUTTON_NAME + (buttonNumber + 1));
            this.jMenuItem = null;
            this.buttonNumber = 0;
            this.buttonNumber = buttonNumber;
            this.setToolTipText("F" + (buttonNumber + 1));
            EasyPanel.this.toolbox.getContext().getWorkbench().getFrame().addKeyboardShortcut(112 + buttonNumber, 0, new PlugIn(){

                public boolean execute(PlugInContext context) throws Exception {
                    CustomButton.this.executeMenuItem();
                    return false;
                }

                public String getName() {
                    return null;
                }

                public void initialize(PlugInContext context) throws Exception {
                }
            }, new MultiEnableCheck());
        }

        public void setMenuItem(JMenuItem jMenuItemToSet) {
            this.jMenuItem = jMenuItemToSet;
            this.setText(this.jMenuItem.getText());
            EasyPanel.this.setPersistentButtonList(EasyPanel.this.toolbox.getContext(), this.buttonNumber, this.jMenuItem.getText());
        }

        public void executeMenuItem() {
            if (this.jMenuItem != null) {
                Component component = ((JPopupMenu)this.jMenuItem.getParent()).getInvoker();
                if (component instanceof JMenu) {
                    JMenu jMenu = (JMenu)component;
                    MenuListener[] menuListeners = jMenu.getMenuListeners();
                    for (int i = 0; i < menuListeners.length; ++i) {
                        if (!(menuListeners[i] instanceof FeatureInstaller.JumpMenuListener)) continue;
                        ((FeatureInstaller.JumpMenuListener)menuListeners[i]).menuSelected(null);
                    }
                } else {
                    JPopupMenu popupMenu = (JPopupMenu)this.jMenuItem.getParent();
                    PopupMenuListener[] listeners = (PopupMenuListener[])popupMenu.getListeners(PopupMenuListener.class);
                    for (int i = 0; i < listeners.length; ++i) {
                        if (!(listeners[i] instanceof PopupMenuListener)) continue;
                        listeners[i].popupMenuWillBecomeVisible(new PopupMenuEvent(popupMenu));
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (CustomButton.this.jMenuItem.isEnabled()) {
                            CustomButton.this.jMenuItem.doClick();
                        } else {
                            String toolTip = CustomButton.this.jMenuItem.getToolTipText();
                            CustomButton.this.setToolTip(toolTip);
                        }
                    }
                });
            }
        }

        public void setButtonEnabled(boolean enabled) {
            this.setEnabled(enabled);
        }

        private void setToolTip(String toolTip) {
            this.setToolTipText(toolTip);
            EasyPanel.this.toolbox.getContext().getWorkbench().getFrame().warnUser(toolTip);
        }
    }

    class PopupListener
    extends MouseAdapter {
        JPopupMenu popup;

        PopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                Component component = e.getComponent();
                this.popup.show(component, e.getX(), e.getY());
                if (component instanceof CustomButton) {
                    EasyPanel.this.activeButton = (CustomButton)component;
                }
            }
        }
    }
}

