/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.view;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelListener;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelListener;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ShowFullPathPlugIn
extends AbstractPlugIn {
    PlugInContext gContext;
    static final String sErrorSeeOutputWindow = I18N.get("org.openjump.core.ui.plugin.view.ShowFullPathPlugIn.Error-See-Output-Window");
    static final String sNumberSelected = I18N.get("org.openjump.core.ui.plugin.view.ShowFullPathPlugIn.NumberSelected");
    private LayerNamePanelListener layerNamePanelListener = new LayerNamePanelListener(){

        public void layerSelectionChanged() {
            List layerCollection = ShowFullPathPlugIn.this.gContext.getWorkbenchContext().getLayerNamePanel().getLayerManager().getLayers();
            for (Layer layer : layerCollection) {
                if (!layer.hasReadableDataSource()) continue;
                DataSourceQuery dsq = layer.getDataSourceQuery();
                String fname = "";
                Object fnameObj = dsq.getDataSource().getProperties().get("File");
                if (fnameObj != null) {
                    fname = fnameObj.toString();
                }
                Object archiveObj = layer.getBlackboard().get("ArchiveFileName");
            }
        }
    };
    private LayerViewPanelListener layerViewPanelListener = new LayerViewPanelListener(){

        public void selectionChanged() {
            LayerViewPanel panel = ShowFullPathPlugIn.this.gContext.getWorkbenchContext().getLayerViewPanel();
            if (panel == null) {
                return;
            }
            Collection selectedFeatures = panel.getSelectionManager().getSelectedItems();
            int numSel = selectedFeatures.size();
            int numPts = 0;
            Iterator i = selectedFeatures.iterator();
            while (i.hasNext()) {
                numPts += ((Geometry)i.next()).getNumPoints();
            }
            Envelope env = ShowFullPathPlugIn.this.envelope(panel.getSelectionManager().getSelectedItems());
            String sx = panel.format(env.getWidth());
            String sy = panel.format(env.getHeight());
            ShowFullPathPlugIn.this.gContext.getWorkbenchFrame().setTimeMessage(sNumberSelected + " " + numSel + " [" + sx + ", " + sy + "] " + numPts + " pts");
        }

        public void cursorPositionChanged(String x, String y) {
        }

        public void painted(Graphics graphics) {
        }
    };

    public void initialize(PlugInContext context) throws Exception {
        this.gContext = context;
        context.getWorkbenchFrame().getDesktopPane().addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent e) {
                Component child = e.getChild();
                if (child.getClass().getName().equals("com.vividsolutions.jump.workbench.ui.TaskFrame")) {
                    ((TaskFrame)child).getLayerNamePanel().addListener(ShowFullPathPlugIn.this.layerNamePanelListener);
                    ((TaskFrame)child).getLayerViewPanel().addListener(ShowFullPathPlugIn.this.layerViewPanelListener);
                }
            }

            public void componentRemoved(ContainerEvent e) {
                Component child = e.getChild();
                if (child.getClass().getName().equals("com.vividsolutions.jump.workbench.ui.TaskFrame")) {
                    ((TaskFrame)child).getLayerNamePanel().removeListener(ShowFullPathPlugIn.this.layerNamePanelListener);
                    ((TaskFrame)child).getLayerViewPanel().removeListener(ShowFullPathPlugIn.this.layerViewPanelListener);
                }
            }
        });
    }

    public boolean execute(PlugInContext context) throws Exception {
        try {
            return true;
        }
        catch (Exception e) {
            context.getWorkbenchFrame().warnUser(I18N.get("org.openjump.core.ui.plugin.layer.AddSIDLayerPlugIn.Error-See-Output-Window"));
            context.getWorkbenchFrame().getOutputFrame().createNewDocument();
            context.getWorkbenchFrame().getOutputFrame().addText("ShowFullPathPlugIn Exception:" + e.toString());
            return false;
        }
    }

    private Envelope envelope(Collection geometries) {
        Envelope envelope = new Envelope();
        for (Geometry geometry : geometries) {
            envelope.expandToInclude(geometry.getEnvelopeInternal());
        }
        return envelope;
    }
}

