/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.window;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.ViewportListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import javax.swing.ButtonGroup;
import javax.swing.JInternalFrame;
import javax.swing.JRadioButtonMenuItem;
import org.openjump.core.ui.plugin.AbstractUiPlugIn;

public class SynchronizationPlugIn
extends AbstractUiPlugIn {
    static ViewportListener vpl;

    public SynchronizationPlugIn(String name) {
        super(name);
    }

    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        JRadioButtonMenuItem desynchronizeMI = new JRadioButtonMenuItem(I18N.get("org.openjump.core.ui.plugin.window.SyncronizationPlugIn.Desynchronize"));
        JRadioButtonMenuItem synchronizePanMI = new JRadioButtonMenuItem(I18N.get("org.openjump.core.ui.plugin.window.SyncronizationPlugIn.Synchronize-pan-only"));
        JRadioButtonMenuItem synchronizeAllMI = new JRadioButtonMenuItem(I18N.get("org.openjump.core.ui.plugin.window.SyncronizationPlugIn.Synchronize-pan-and-zoom"));
        ButtonGroup bgroup = new ButtonGroup();
        bgroup.add(desynchronizeMI);
        bgroup.add(synchronizePanMI);
        bgroup.add(synchronizeAllMI);
        desynchronizeMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SynchronizationPlugIn.this.desynchronize();
            }
        });
        synchronizePanMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SynchronizationPlugIn.this.synchronize(false);
            }
        });
        synchronizeAllMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SynchronizationPlugIn.this.synchronize(true);
            }
        });
        context.getFeatureInstaller().addMainMenuItem(new String[]{MenuNames.WINDOW, MenuNames.WINDOW_SYNCHRONIZATION}, this, synchronizePanMI, 0);
        context.getFeatureInstaller().addMainMenuItem(new String[]{MenuNames.WINDOW, MenuNames.WINDOW_SYNCHRONIZATION}, this, synchronizeAllMI, 1);
        context.getFeatureInstaller().addMainMenuItem(new String[]{MenuNames.WINDOW, MenuNames.WINDOW_SYNCHRONIZATION}, this, desynchronizeMI, 2);
    }

    public String getName() {
        return I18N.get("org.openjump.core.ui.plugin.window.SyncronizationPlugIn.Synchronization");
    }

    public EnableCheck getEnableCheck() {
        EnableCheckFactory checkFactory = new EnableCheckFactory(this.workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
    }

    public void synchronize(boolean panAndZoom) {
        JInternalFrame[] iframes;
        ViewportListener oldViewportListener = vpl;
        vpl = this.createViewportListener(panAndZoom);
        for (JInternalFrame iframe : iframes = this.workbenchContext.getWorkbench().getFrame().getInternalFrames()) {
            if (!(iframe instanceof TaskFrame)) continue;
            ((TaskFrame)iframe).getLayerViewPanel().getViewport().removeListener(oldViewportListener);
            ((TaskFrame)iframe).getLayerViewPanel().getViewport().addListener(vpl);
        }
    }

    public void desynchronize() {
        JInternalFrame[] iframes;
        ViewportListener oldViewPortListener = vpl;
        vpl = null;
        for (JInternalFrame iframe : iframes = this.workbenchContext.getWorkbench().getFrame().getInternalFrames()) {
            if (!(iframe instanceof TaskFrame)) continue;
            ((TaskFrame)iframe).getLayerViewPanel().getViewport().removeListener(oldViewPortListener);
        }
    }

    private ViewportListener createViewportListener(final boolean panAndZoom) {
        final WorkbenchContext context = this.workbenchContext;
        return new ViewportListener(){

            public void zoomChanged(Envelope modelEnvelope) {
                JInternalFrame[] iframes;
                for (JInternalFrame iframe : iframes = context.getWorkbench().getFrame().getInternalFrames()) {
                    if (!(iframe instanceof TaskFrame) || ((TaskFrame)iframe).getLayerViewPanel().getViewport() == context.getLayerViewPanel().getViewport()) continue;
                    try {
                        Viewport viewport = ((TaskFrame)iframe).getLayerViewPanel().getViewport();
                        double w = viewport.getPanel().getWidth();
                        double h = viewport.getPanel().getHeight();
                        double scale = viewport.getScale();
                        if (panAndZoom) {
                            scale = Math.min(w / modelEnvelope.getWidth(), h / modelEnvelope.getHeight());
                        }
                        double xCenteringOffset = (w / scale - modelEnvelope.getWidth()) / 2.0;
                        double yCenteringOffset = (h / scale - modelEnvelope.getHeight()) / 2.0;
                        Point2D.Double viewOriginAsPerceivedByModel = new Point2D.Double(modelEnvelope.getMinX() - xCenteringOffset, modelEnvelope.getMinY() - yCenteringOffset);
                        viewport.initialize(scale, viewOriginAsPerceivedByModel);
                        viewport.update();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        };
    }

    public boolean execute(PlugInContext context) throws Exception {
        return true;
    }
}

