/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.style.decoration;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.renderer.style.LineStringSegmentStyle;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;

public abstract class SegmentDownhillArrowStyle
extends LineStringSegmentStyle {
    private static final double SMALL_ANGLE = 10.0;
    private static final double MEDIUM_ANGLE = 30.0;
    private static final double MEDIUM_LENGTH = 10.0;
    private static final double LARGE_LENGTH = 15.0;
    private boolean filled;
    private double finAngle;
    protected double finLength;

    public SegmentDownhillArrowStyle(String name, String iconFile, double finAngle, double finLength, boolean filled) {
        super(I18N.get(SegmentDownhillArrowStyle.class.getName() + "." + name), IconLoader.icon(iconFile));
        this.finAngle = finAngle;
        this.finLength = finLength;
        this.filled = filled;
    }

    private GeneralPath arrowhead(Point2D shaftTip, Point2D shaftTail, double finLength, double finAngle) {
        GeneralPath arrowhead = new GeneralPath();
        Point2D finTip1 = this.fin(shaftTip, shaftTail, finLength, finAngle);
        Point2D finTip2 = this.fin(shaftTip, shaftTail, finLength, -finAngle);
        arrowhead.moveTo((float)finTip1.getX(), (float)finTip1.getY());
        arrowhead.lineTo((float)shaftTip.getX(), (float)shaftTip.getY());
        arrowhead.lineTo((float)finTip2.getX(), (float)finTip2.getY());
        return arrowhead;
    }

    private Point2D fin(Point2D shaftTip, Point2D shaftTail, double length, double angle) {
        double shaftLength = shaftTip.distance(shaftTail);
        Point2D finTail = shaftTip;
        Point2D finTip = GUIUtil.add(GUIUtil.multiply(GUIUtil.subtract(shaftTail, shaftTip), length / shaftLength), finTail);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(angle * Math.PI / 180.0, finTail.getX(), finTail.getY());
        return affineTransform.transform(finTip, null);
    }

    protected void paint(Coordinate terminal, Coordinate next, Viewport viewport, Graphics2D graphics) throws Exception {
        Point2D startPoint = viewport.toViewPoint(new Point2D.Double(terminal.x, terminal.y));
        Point2D endPoint = viewport.toViewPoint(new Point2D.Double(next.x, next.y));
        if (terminal.z != next.z && !Double.isNaN(terminal.z) && !Double.isNaN(next.z)) {
            if (terminal.z < next.z) {
                this.paint(startPoint, endPoint, viewport, graphics);
            } else {
                this.paint(endPoint, startPoint, viewport, graphics);
            }
        }
    }

    protected void paint(Point2D terminal, Point2D next, Viewport viewport, Graphics2D graphics) throws NoninvertibleTransformException {
        if (terminal.equals(next)) {
            return;
        }
        graphics.setColor(this.lineColorWithAlpha);
        graphics.setStroke(this.stroke);
        Point middle = new Point();
        ((Point2D)middle).setLocation((terminal.getX() + next.getX()) / 2.0, (terminal.getY() + next.getY()) / 2.0);
        GeneralPath arrowhead = this.arrowhead(middle, next, this.finLength, this.finAngle);
        if (this.filled) {
            arrowhead.closePath();
            graphics.fill(arrowhead);
        }
        graphics.draw(arrowhead);
    }

    public static class NarrowSolidMiddle
    extends SegmentDownhillArrowStyle {
        public NarrowSolidMiddle() {
            super("SolidNarrow", "ArrowMidSolidNarrow.gif", 10.0, 15.0, true);
        }
    }

    public static class Solid
    extends SegmentDownhillArrowStyle {
        public Solid() {
            super("Solid", "ArrowMidSolid.gif", 30.0, 10.0, true);
        }
    }

    public static class Open
    extends SegmentDownhillArrowStyle {
        public Open() {
            super("Open", "ArrowMidOpen.gif", 30.0, 10.0, false);
        }
    }
}

