/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.style.decoration;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.ChoosableStyle;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import javax.swing.Icon;

public abstract class TextBasedVertexStyle
implements ChoosableStyle {
    protected boolean enabled = true;
    protected String name;
    protected Icon icon;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }

    public TextBasedVertexStyle() {
    }

    public TextBasedVertexStyle(String name, Icon icon) {
        this.name = name;
        this.icon = icon;
    }

    protected void paintGeometry(Geometry geometry, Graphics2D graphics, Viewport viewport) throws Exception {
        if (geometry instanceof GeometryCollection) {
            this.paintGeometryCollection((GeometryCollection)geometry, graphics, viewport);
            return;
        }
        if (geometry instanceof Polygon) {
            this.paintPolygon((Polygon)geometry, graphics, viewport);
            return;
        }
        if (geometry instanceof Point) {
            this.paintPoint((Point)geometry, viewport, graphics);
            return;
        }
        if (!(geometry instanceof LineString)) {
            return;
        }
        LineString lineString = (LineString)geometry;
        if (lineString.getNumPoints() < 2) {
            return;
        }
        this.paintLineString(lineString, viewport, graphics);
    }

    protected void paintLineString(LineString lineString, Viewport viewport, Graphics2D graphics) throws Exception {
        int numPtsToRender = lineString.getNumPoints();
        if (lineString.isClosed()) {
            --numPtsToRender;
        }
        for (int i = 0; i < numPtsToRender; ++i) {
            Coordinate p = lineString.getCoordinateN(i);
            this.paint(viewport.toViewPoint(new Point2D.Double(p.x, p.y)), lineString, i, viewport, graphics);
        }
    }

    protected abstract void paint(Point2D var1, LineString var2, int var3, Viewport var4, Graphics2D var5) throws Exception;

    protected abstract void paintPoint(Point var1, Viewport var2, Graphics2D var3) throws Exception;

    private void paintGeometryCollection(GeometryCollection gc, Graphics2D graphics, Viewport viewport) throws Exception {
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            this.paintGeometry(gc.getGeometryN(i), graphics, viewport);
        }
    }

    private void paintPolygon(Polygon polygon, Graphics2D graphics, Viewport viewport) throws Exception {
        this.paintGeometry((Geometry)polygon.getExteriorRing(), graphics, viewport);
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            this.paintGeometry((Geometry)polygon.getInteriorRingN(i), graphics, viewport);
        }
    }

    public void initialize(Layer layer) {
    }

    public void paint(Feature f, Graphics2D g, Viewport viewport) throws Exception {
        this.paintGeometry(f.getGeometry(), g, viewport);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getName() {
        return this.name;
    }

    public Icon getIcon() {
        return this.icon;
    }
}

