/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.swing;

import com.vividsolutions.jump.I18N;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

public class OkCancelButtonPanel
extends JPanel {
    private static final long serialVersionUID = -4703181650847522122L;
    public static final String OK_BUTTON_ACTION_COMMAND = new String("OK_BUTTON_ACTION_COMMAND");
    public static final String CANCEL_BUTTON_ACTION_COMMAND = new String("CANCEL_BUTTON_ACTION_COMMAND");
    private JButton cancelButton;
    private JButton okButton;

    public OkCancelButtonPanel() {
        this.initialize();
    }

    public void addActionListener(ActionListener listener) {
        this.getOkButton().addActionListener(listener);
        this.getCancelButton().addActionListener(listener);
    }

    public JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText(I18N.get("ui.OKCancelPanel.cancel"));
            this.cancelButton.setActionCommand(CANCEL_BUTTON_ACTION_COMMAND);
            this.cancelButton.setFocusPainted(false);
        }
        return this.cancelButton;
    }

    public JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText(I18N.get("ui.OKCancelPanel.ok"));
            this.okButton.setActionCommand(OK_BUTTON_ACTION_COMMAND);
            this.okButton.setFocusPainted(false);
        }
        return this.okButton;
    }

    public void setOkButtonEnabled(boolean enable) {
        this.getOkButton().setEnabled(enable);
    }

    private void initialize() {
        this.setSize(300, 40);
        this.setLayout(new BoxLayout(this, 2));
        this.add(Box.createHorizontalGlue(), null);
        this.add((Component)this.getCancelButton(), null);
        this.add(Box.createRigidArea(new Dimension(10, 0)));
        this.add((Component)this.getOkButton(), null);
        this.requestFocus();
    }

    public void requestFocus() {
        this.okButton.setFocusable(true);
        this.okButton.requestFocus();
    }
}

