/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.swing.listener;

import de.fho.jump.pirol.utilities.debugOutput.DebugUserIds;
import de.fho.jump.pirol.utilities.debugOutput.PersonalLogger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import org.openjump.core.ui.swing.OkCancelButtonPanel;
import org.openjump.core.ui.swing.ValueChecker;

public class OKCancelListener
implements ActionListener {
    protected boolean okWasClicked = false;
    protected JDialog dialog = null;
    protected PersonalLogger logger = new PersonalLogger(DebugUserIds.ALL);
    protected ArrayList valueCheckers = new ArrayList();

    public OKCancelListener(JDialog dialog) {
        this.dialog = dialog;
    }

    public void addValueChecker(ValueChecker valChecker) {
        this.valueCheckers.add(valChecker);
    }

    public void actionPerformed(ActionEvent arg0) {
        try {
            JButton button = (JButton)arg0.getSource();
            if (button.getActionCommand().equals(OkCancelButtonPanel.OK_BUTTON_ACTION_COMMAND)) {
                if (!this.valuesOk()) {
                    return;
                }
                this.okWasClicked = true;
            }
            if (this.dialog != null) {
                this.dialog.setVisible(false);
                this.dialog.dispose();
            }
        }
        catch (ClassCastException e) {
            this.logger.printError(e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    protected boolean valuesOk() {
        if (this.valueCheckers.isEmpty()) {
            return true;
        }
        boolean valsOk = true;
        ValueChecker[] valueCheckerArray = this.valueCheckers.toArray(new ValueChecker[0]);
        for (int i = 0; i < valueCheckerArray.length; ++i) {
            valsOk = valsOk && valueCheckerArray[i].areValuesOk();
        }
        return valsOk;
    }

    public boolean wasOkClicked() {
        return this.okWasClicked;
    }
}

