/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.util;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.zip.ZipEntry;

public final class UriUtil {
    private UriUtil() {
    }

    public static URI getUri(File file, ZipEntry entry) {
        try {
            String entryName = entry.getName();
            URI fileUri = file.toURI();
            String filePath = fileUri.getPath();
            URI uri = new URI("zip", null, filePath + "!/" + entryName, null);
            return uri;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Cannot create URI for " + file + "!/" + entry);
        }
    }

    public static File getZipFile(URI uri) {
        String path = uri.getPath();
        int index = path.indexOf(33);
        if (index == -1) {
            return new File(uri);
        }
        try {
            URI fileUri = new URI("file", null, path.substring(0, index), null);
            return new File(fileUri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String getZipEntryName(URI uri) {
        String path = uri.getPath();
        int index = path.indexOf(33);
        if (index == -1) {
            return null;
        }
        return path.substring(index + 2);
    }

    public static String getFileExtension(URI uri) {
        String path = uri.getPath();
        int dotIndex = path.lastIndexOf(46);
        if (dotIndex != -1) {
            return path.substring(dotIndex + 1);
        }
        return "";
    }

    public static String getFileName(URI uri) {
        String path = uri.getPath();
        int slashIndex = path.lastIndexOf(47);
        if (slashIndex != -1) {
            return path.substring(slashIndex + 1);
        }
        return "";
    }

    public static String getFileNameWithoutExtension(URI uri) {
        String name = UriUtil.getFileName(uri);
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex != -1) {
            return name.substring(0, dotIndex);
        }
        return "";
    }

    public static String getZipEntryFilePath(URI uri) {
        String name = UriUtil.getZipEntryName(uri);
        int slashIndex = name.lastIndexOf(47);
        if (slashIndex != -1) {
            return name.substring(0, slashIndex);
        }
        return null;
    }
}

